function timeLFP(suffix)
% TIME LFP - Write out raw lfp and spike data for each trial.
%

    % Read parameters file.
    Params = read_params(suffix);
    pass_band = [Params.freq_start_1, Params.freq_end_1, Params.freq_step_1];
    if not(all(pass_band > 0))
        pass_band = [];
    end

    % Load lfp data
    [lfps, fs, trial_type, trial_index] = ...
            load_lfps(Params.data_directory, Params.command_line,   ...
                      Params.trial_file, Params.time_interval,      ...
                      Params.alpha_plex, Params.electrode_1,        ...
                      pass_band, Params.remove_mean);

    % Load spike data
    spikes = load_spikes(Params.trial_file, Params.spike_file,      ...
                         Params.time_interval, fs, trial_index);

    % Write data out
    fid = fopen(['data', suffix],'w');
    fprintf(fid, '%s\n', char(Params.command_line));
    fprintf(fid, '%s\n', Params.data_directory);
    fprintf(fid, '%s\n', Params.params_str);
    fprintf(fid, '%d\n', size(lfps, 1));        % n trials
    fprintf(fid, '%d\n', size(lfps, 2));        % n samples per trial
    for i_trial = 1:size(lfps,1)
        fprintf(fid, '%s\n', ...
                sprintf('%d %d', trial_index(i_trial), trial_type(i_trial)));
        fprintf(fid, '%s\n', sprintf('%d ', spikes(i_trial, :)));
        fprintf(fid, '%s\n', sprintf('%d ', lfps(i_trial, :)));
    end
    fclose(fid);

end
