function phasePairLFP(suffix)
% Phase Pair LFP:
%	LFP-LFP Pairwise Phase Consistency
%  

    % Read parameters
    Params = read_params(suffix);
    freq = Params.freq_start_1 : Params.freq_step_1 : Params.freq_end_1;
    time_window = Params.time_1;
    time_step = time_window / 4;
    TW = Params.freq_start_2 / 10;
    n_tapers = floor(2 * TW - 1);

    % Load lfp data.
    [lfps_1, fs, trial_type] =  ...
            load_lfps(Params.data_directory, Params.command_line,   ...
                      Params.trial_file, Params.time_interval,      ...
                      Params.alpha_plex, Params.electrode_1, [],    ...
                      Params.remove_mean);
    lfps_2 = load_lfps(Params.data_directory, Params.command_line,   ...
                       Params.trial_file, Params.time_interval,      ...
                       Params.alpha_plex, Params.electrode_2, []     ...
                       Params.remove_mean);

    % Get all trial types and trial counts for each type.
    type_list = unique(trial_type);
    n_trials = arrayfun(@(x) sum(trial_type == x), type_list);

    % Spectra, cross-spectra, and phase differences
    S1 = mt_dtft_gram(lfps_1, fs, time_window, time_step, freq, TW, n_tapers);
    S2 = mt_dtft_gram(lfps_2, fs, time_window, time_step, freq, TW, n_tapers);
    S12 = mean(S1 .* conj(S2), 4);
    phase_diff = angle(S12);

    for i_type = 1:numel(type_list)
        these_phase_diff = phase_diff(trial_type == type_list(i_type), :, :);
        ppc_vals(i_type, :, :) = 1 - var(cos(these_phase_diff), [], 1)  ...
                                   - var(sin(these_phase_diff), [], 1);
        % Equation from supplement of Kornblith et al. 2016 
        %   (doi: 10.1093/cercor/bhv182).
    end

    % Output data
    fid = fopen(['data', suffix], 'w');
    fprintf(fid, '%s\n', char(Params.command_line));
    fprintf(fid, '%s\n', Params.data_directory);
    fprintf(fid, '%s\n', Params.params_str);
    fprintf(fid, '%s\n', sprintf('%d ', n_trials));
	for i_type = 1:size(ppc_vals, 1)
		for i_freq = 1:size(ppc_vals, 2)
			fprintf(fid, '%s\n', sprintf('%g ', ppc_vals(i_type, i_freq, :)));
		end
	end
    fclose(fid);

end
