function evokedLFP(suffix)
% EVOKED LFP
% Output: 
%	Writes out evoked LFP.
%

    % Import parameters
    Params = read_params(suffix);
    pass_band = [Params.freq_start_1, Params.freq_end_1, Params.freq_step_1];
    if not(all(pass_band > 0))
        pass_band = [];
    end

    % Load lfp data
    [lfps, fs, trial_type] = ...
            load_lfps(Params.data_directory, Params.command_line,   ...
                      Params.trial_file, Params.time_interval,      ...
                      Params.alpha_plex, Params.electrode_1,        ...
                      pass_band, Params.remove_mean);

    % Get all trial types and count nTrials
    type_list = unique(trial_type);
    n_trials = arrayfun(@(x) sum(trial_type == x), type_list);

    % Average by trial type
    for i_type = 1:length(type_list)
        these_lfps = lfps(trial_type == type_list(i_type), :);
        lfp_mean(i_type, :) = mean(these_lfps, 1);
        lfp_std(i_type, :) = std(these_lfps, [], 1);
    end

    % Output data
    fid = fopen(['data', suffix], 'w');
    fprintf(fid, '%s\n', char(Params.command_line));
    fprintf(fid, '%s\n', Params.data_directory);
    fprintf(fid, '%s\n', Params.params_str);
    for i_type = 1:numel(type_list)
        fprintf(fid, '%d %d\n', type_list(i_type), n_trials(i_type));
        fprintf(fid, '%s\n', sprintf('%10.5f ', lfp_mean(i_type, :)));
        fprintf(fid, '%s\n', sprintf('%10.5f ', lfp_std(i_type, :)));
    end
    fclose(fid);

end
