function corLFP(suffix)
% CORRELATE LFPs 
%

    % Read parameters
    Params = read_params(suffix);
    pass_band = [Params.freq_start_1, Params.freq_end_1, Params.freq_step_1];
    if not(all(pass_band > 0))
        pass_band = [];
    end

    % Read lfp data
    [lfps_1, fs, trial_type] =  ...
            load_lfps(Params.data_directory, Params.command_line,   ...
                      Params.trial_file, Params.time_interval,      ...
                      Params.alpha_plex, Params.electrode_1,        ...
                      pass_band, Params.remove_mean);
    lfps_2 = load_lfps(Params.data_directory, Params.command_line,  ...
                       Params.trial_file, Params.time_interval,     ...
                       Params.alpha_plex, Params.electrode_2,       ...
                       pass_band, Params.remove_mean);

    % Get all trial types and trial counts for each type.
    type_list = unique(trial_type);
    n_trials = arrayfun(@(x) sum(trial_type == x), type_list);

    % Iterate through all trials. Calculate each trial's correlation.
    for i_trial = 1:size(lfps_1, 1)
        [r, p] = corrcoef(lfps_1(i_trial, :), lfps_2(i_trial, :));
        r_trial(i_trial) = r(1, 2);
        p_trial(i_trial) = p(1, 2);
    end
    z_trial = atanh(r_trial);   % Fisher z-transform

    %Iterate through each trial type - matlab iterates through columns in a list, not rows, so it needs to be size 1 x N
    for i_type = 1:numel(type_list)
        these_z = z_trial(trial_type == type_list(i_type));
        z_type(i_type) = mean(these_z);
        [~, p_type(i_type)] = ttest(these_z, 0, 0.05, 'both');
    end
    r_type = tanh(z_type);      % Fisher z-untransform

    % Output data
    fid = fopen(['data', suffix], 'w');
    fprintf(fid, '%s\n', Params.command_line);
    fprintf(fid, '%s\n', Params.data_directory);
    fprintf(fid, '%s\n', Params.params_str);
    fprintf(fid, '%s\n', sprintf('%d ', type_list));
    fprintf(fid, '%s\n', sprintf('%d ', n_trials));
    fprintf(fid, '%s\n', sprintf('%g ', r_type));
    fprintf(fid, '%s\n', sprintf('%g ', p_type));
    fprintf(fid, '\nTrialType\tR\tp\n');
    fprintf(fid, '%d %g %g\n', [trial_type.'; r_trial; p_trial]);
    fclose(fid);

end
