function cohgramSpikeLFP(suffix)
% COHERENCE TIME FREQUENCY PLOT
%   Uses chronux.
%

    addpath(genpath(['/data/code/grab/2018/_macros/lfp/chronux_2_12/',  ...
                     'spectral_analysis']))

    % Load parameters
    Params = read_params(suffix);
    freq_bounds = [Params.freq_start_1, Params.freq_end_1];
    time_window = Params.time_1;
    time_step = time_window / 4;
    TW = Params.freq_start_2 / 10;
    n_tapers = floor(2 * TW - 1);

    % Load lfp data
    [lfps, fs, trial_type, trial_index] = ...
            load_lfps(Params.data_directory, Params.command_line,   ...
                      Params.trial_file, Params.time_interval,      ...
                      Params.alpha_plex, Params.electrode_1, [],    ...
                      Params.remove_mean);

    % Load spike data
    spikes = load_spikes(Params.trial_file, Params.spike_file,      ...
                         Params.time_interval, fs, trial_index);

    % Get all trial types and trial counts for each type.
    type_list = unique(trial_type);
    n_trials = arrayfun(@(x) sum(trial_type == x), type_list);

    % Compute coheregrams
    for i_type = 1:numel(type_list)


        % Set up chronux parameters, which use sec and Hz for all values.
        movingwin = [time_window, time_step] / 1e3;
        Params_Chronux.tapers = [TW, n_tapers];
        Params_Chronux.Fs = fs * 1e3;
        Params_Chronux.fpass = freq_bounds;
        Params_Chronux.trialave = 1;

        is_type = trial_type == type_list(i_type);
        [C, phi, ~, ~, ~, ~, freq_out] =    ...
                cohgramcpb(lfps(is_type, :).', spikes(is_type, :).',    ...
                           movingwin, Params_Chronux);
        % TODO: Handle spike thinning

        coh_mag(i_type, :, :) = C.';    % Type x freq x time
        coh_angle(i_type, :, :) = phi.';
    end

    % Output data
    fid = fopen(['data', suffix], 'w');
    fid = fopen(['data', suffix], 'w');
    fprintf(fid, '%s\n', char(Params.command_line));
    fprintf(fid, '%s\n', Params.data_directory);
    fprintf(fid, '%s\n', Params.params_str);
    fprintf(fid, '%s\n', sprintf('%d ', n_trials));
    fprintf(fid, '%s\n', sprintf('%g ', freq_out));
    for i_type = 1:size(coh_mag, 1)
        for i_freq = 1:size(coh_mag, 2)
            fprintf(fid, '%s\n',    ...
                    sprintf('%1.10f ', coh_mag(i_type, i_freq, :)));
            fprintf(fid, '%s\n',    ...
                    sprintf('%3.5f ', rad2deg(coh_angle(i_type, i_freq, :))));
        end
    end
    fclose(fid);

end
