/* FILE _macros/switch/split.c */
     /* Split by same/diff or by identity of previous trial (append '1')*/
/* ********************************************************************	*/

#include "../Deffs.h"


/* ********************************************************************	*/
/* Trials after same effector/direction/trial type: StackNumber += 1000	*/

/* ********************************************************************	*/

/* FUNCTION SplitByEffector106 */
	 /* Split data into trials following same/diff effector */
void SplitByEffector106(char *file) {
	void   UnRead_Data();				/* input.c	*/

	int    PrevEffector;

	Rewind_InputFile();
	Read_Next_Trial(WITH_DATA);

	Open_OutputFile( file , ".split") ;

	PrevEffector = StackNumber_Header() % 10;	/* Last digit	*/

	while (Read_Next_Trial(WITH_DATA)) {
	   int Effector = StackNumber_Header() % 10;

	   UnRead_Data();		/* 'Write_OutputFile' expects	*/

	   if (Effector == PrevEffector)
	      Set_StackNumber_Header(StackNumber_Header() + 1000);
	   PrevEffector = Effector;

	   Write_OutputFile();
	   }

	Close_OutputFile();
	}
/* ********************************************************************	*/

/* FUNCTION SplitByClass107 */
	 /* Split data into trials following same/diff class */
void SplitByClass107(char *file) {
	void   UnRead_Data();				/* input.c	*/
	int    PrevClass;

	Rewind_InputFile();
	Read_Next_Trial(WITH_DATA);

	PrevClass = TableNumber_Header();

	Open_OutputFile( file , ".split") ;

	while (Read_Next_Trial(WITH_DATA)) {
	   int Class = TableNumber_Header();

	   UnRead_Data();		/* 'Write_OutputFile' expects	*/

	   if (Class == PrevClass)
	      Set_StackNumber_Header(StackNumber_Header() + 1000);

	   PrevClass = Class;

	   Write_OutputFile();
	   }

	Close_OutputFile();
	}
/* ********************************************************************	*/

/* FUNCTION SplitByTrialType108 */
	 /* Split data into trials following same/diff TrialType */
void SplitByTrialType108(char *file) {
	void   UnRead_Data();				/* input.c	*/
	int    PrevTrialType;

	Rewind_InputFile();
	Read_Next_Trial(WITH_DATA);

	PrevTrialType = (StackNumber_Header() / 10) % 10;

	Open_OutputFile( file , ".split") ;

	while (Read_Next_Trial(WITH_DATA)) {
	   int TrialType = (StackNumber_Header() / 10) % 10;

	   UnRead_Data();		/* 'Write_OutputFile' expects	*/

	   if (TrialType == PrevTrialType)
	      Set_StackNumber_Header(StackNumber_Header() + 1000);

	   PrevTrialType = TrialType;

	   Write_OutputFile();
	   }

	Close_OutputFile();
	}
/* ********************************************************************	*/

/* FUNCTION SplitByEffector1061 */
	 /* Split data into trials following same/diff effector */
void SplitByEffector1061(char *file) {
	void   UnRead_Data();				/* input.c	*/
	int    PrevEffector;

	Open_OutputFile( file , ".split") ;
	Rewind_InputFile();
	Read_Next_Trial(WITH_DATA);

	PrevEffector = StackNumber_Header() % 10;	/* Last digit	*/

	while (Read_Next_Trial(WITH_DATA)) {
	   UnRead_Data();		/* 'Write_OutputFile' expects	*/
	   Set_StackNumber_Header(StackNumber_Header() + PrevEffector * 1000);
	   Write_OutputFile();
	   PrevEffector = (StackNumber_Header() % 10)/2;/* Last digit/2	*/
	   }
	Close_OutputFile();
	}
/* ********************************************************************	*/

/* FUNCTION SplitByClass1071 */
	 /* Split data into trials following same/diff class */
void SplitByClass1071(char *file) {
	void   UnRead_Data();				/* input.c	*/
	int    PrevClass;

	Open_OutputFile(file , ".split") ;
	Rewind_InputFile();
	Read_Next_Trial(WITH_DATA);

	PrevClass = TableNumber_Header();

	while (Read_Next_Trial(WITH_DATA)) {
	   UnRead_Data();		/* 'Write_OutputFile' expects	*/
	   Set_StackNumber_Header(StackNumber_Header() +
				 (List_Index(PrevClass,CLASS)-1) * 1000);
	   PrevClass = TableNumber_Header();
	   Write_OutputFile();
	   }
	Close_OutputFile();
	}
/* ********************************************************************	*/

/* FUNCTION SplitByTrialType1081 */
	 /* Split data into trials following same/diff TrialType */
void SplitByTrialType1081(char *file) {
	void   UnRead_Data();				/* input.c	*/
	int    PrevTrialType;

	Open_OutputFile( file , ".split") ;
	Rewind_InputFile();
	Read_Next_Trial(WITH_DATA);

	PrevTrialType = (StackNumber_Header() / 10) % 10;

	while (Read_Next_Trial(WITH_DATA)) {
	   UnRead_Data();		/* 'Write_OutputFile' expects	*/
	   Set_StackNumber_Header(StackNumber_Header() + PrevTrialType * 1000);
	   PrevTrialType = (StackNumber_Header() / 10) % 10;
	   Write_OutputFile();
	   }
	Close_OutputFile();
	}
/* ********************************************************************	*/
