/* FILE _macros/intent.c */
     /* Ttest on directional activity */
/* ********************************************************************	*/

#include "../Deffs.h"

/* ********************************************************************	*/

#define	VERBOSE 	0


static void Test_Against_Zero(FILE *out, int stack, int type);
static void Test_Intervals_Against_Each_Other(FILE *out, int stack, int type);
static void Test_Stacks_Against_Each_Other(FILE *out,
				int stack1, int stack2, int type1, int type2);
/* ********************************************************************	*/

/* FUNCTION TestArmVsEye */
	 /* Write individual trial data out for Splus import	*/
	 /* Append any arguments to 'title' to end of file	*/
	 /* Use '-D' to specify Intention (cuetarg), Delay (targcue),
	 	Cued Memory, Spatial Memory			*/
	 /* Use '-d' to specify preferred direction to look at	*/
	 /*   Use -d-1 to specify, "consult best_* file"	*/
void TestArmVsEye100() {
	FILE *file;
	char Name[80];
	int ArmStack, EyeStack, TwoStack;
	int ArmType, EyeType, TwoType;
	int Type = Get_DataValue_From_CmdLine();
	int Class = Get_dataValue_From_CmdLine();
			/* Both *_From_CmdLines default to 0	*/

	if (Type == 0)	/* If nothing specified on cmdline	*/
	   Type = 200;	/* Then do intention (200,202,204)	*/

	ArmStack = Type;
	EyeStack = Type + 2;
	TwoStack = Type + 4;

	if (Class == -1) {
	   sprintf(Name, "best_%d.%d", UnitNumber_Header(), RunNumber_Header());
	   file = fopen(Name, "r");

	   if (file == NULL) {
	      int i;			/* Try other run numbers	*/
	      for (i=RunNumber_Header()-1; i>0; i--) {
	         sprintf(Name, "best_%d.%d", UnitNumber_Header(), i);
	         file = fopen(Name, "r");
		 if (file != NULL)
		    break;
		 }
	      if (file == NULL)
	       for (i=RunNumber_Header()+1; i<30; i++) {
	         sprintf(Name, "best_%d.%d", UnitNumber_Header(), i);
	         file = fopen(Name, "r");
		 if (file != NULL)
		    break;
		 }
	      if (file == NULL) {
	         fprintf(stderr, "No 'best' file (unit %d)\n",
		 				UnitNumber_Header());
		 return;
		 }
	      }
	   fscanf(file, "%d", &Class);	/* GET BEST CLASS FROM FILE! */
	   }

        if (Class == 0)
	    Class = List_Element(0,CLASS);

	ArmType = Get_StackClass_TrialType(ArmStack, Class);
	EyeType = Get_StackClass_TrialType(EyeStack, Class);
	TwoType = Get_StackClass_TrialType(TwoStack, Class);

	Rewind_InputFile();		/* For consistent unit,run#	*/
   	sprintf(Name, "Intent.%d.%d", UnitNumber_Header(), RunNumber_Header());
   	/* sprintf(Name, "ttest.%d.%d.%s", UnitNumber_Header(),
	 		* RunNumber_Header(), Get_AlignmentTime() + 1); */
  	file = fopen(Name, (MACRO_APPENDS)?"a":"w");
   	if (file==NULL) {
      	   fprintf(stderr, "Err opening %s", Name);
      	   Exit("", "TestArmVsEye100()");
      	   }

	if (VERBOSE && Get_Interval_Type() != 1) {
	   fprintf(file, "\n\nDatafile: %d.%d\n\n",
	   		UnitNumber_Header(), RunNumber_Header()); 
	   fprintf(file, "Interval: %d to %d ms\n",
	   		Get_Interval_Begin(1), Get_Interval_End(1)); 
	   fprintf(file, "Background: %d to %d ms\n\n",
	   		Get_Interval_Begin(2), Get_Interval_End(2)); 
	   fprintf(file, "Is each stack different from background?\n");
	   fprintf(file, " Stack  P-value      mean    n\n");
	   }

	      /* First, test if each stack is signif against background	*/
	switch (Get_Interval_Type()) {
	   case 1:		/* No bg interval; can only cmp effects	*/
	       if (!VERBOSE) {
	         fprintf(file, "%4d %5.4f %5.1f %3d\n", ArmStack, 1., 0., 0);
	         fprintf(file, "%4d %5.4f %5.1f %3d\n", EyeStack, 1., 0., 0);
	         fprintf(file, "%4d %5.4f %5.1f %3d\n", TwoStack, 1., 0., 0);
		 }
	 	break;

	   case 2:		/* Is fg firing (-i) diff from bg (-B)?	*/
		Test_Against_Zero(file, ArmStack, ArmType);
		Test_Against_Zero(file, EyeStack, EyeType);
		Test_Against_Zero(file, TwoStack, TwoType);
		break;

	   case 3:		/* Is fg firing (-i) diff from bg (-I)?	*/
	   	Test_Intervals_Against_Each_Other(file, ArmStack, ArmType);
	   	Test_Intervals_Against_Each_Other(file, EyeStack, EyeType);
	   	Test_Intervals_Against_Each_Other(file, TwoStack, TwoType);
		break;
		}
	fprintf(file, "\n");

	if (VERBOSE) {
	   fprintf(file,"\n\nDatafile: %d.%d\n\n",
	   			UnitNumber_Header(), RunNumber_Header()); 
	   fprintf(file,"Interval: %d to %d ms\n\n",
	   			Get_Interval_Begin(1), Get_Interval_End(1)); 
	   fprintf(file,"Are stacks different from each other?\n");
	   fprintf(file,"Stack-1 vs stack-2    P-value   mean-1  mean-2   n\n");
	   }

	      /* Now, test if stacks are different from each other	*/
	      /* Cmp either fg (-i) or fg-bg (-i,-B) intervals		*/
	Test_Stacks_Against_Each_Other(file,ArmStack,EyeStack,ArmType,EyeType);
	Test_Stacks_Against_Each_Other(file,TwoStack,ArmStack,TwoType,ArmType);
	Test_Stacks_Against_Each_Other(file,TwoStack,EyeStack,TwoType,EyeType);

	/* If interval == 3, then we could make a new array, subtract
	 * -i from -I interval on a trial by trial basis for both stacks,
	 * and then do a ttest of the resultant arrays, stack against
	 * stack.  (In other words, subract the bg from the fg on a
	 * trial by trial basis).
	 */

	fclose(file);
	}
/* ********************************************************************	*/

/* FUNCTION Test_Against_Zero */
	 /* Test interval 1 (-i minus -B) against zero */
static void Test_Against_Zero(FILE *out, int stack, int type) {
	float Pvalue;

	if (type == FAIL) {
	   if (!VERBOSE)
	      fprintf(out, "%4d %5.4f %5.1f %3d\n", stack, 1., 0., 0);
	   return;
	   }

	Pvalue = Ttest_vs_zero( Get_Interval_Data(type,1),
		       		Get_Interval_Count(type,1),
		       		1),			/* One-sided	*/

	fprintf(out, "%4d    %5.4f    %5.1f %3d", stack,
		Pvalue,
		Get_Interval_Mean(type,1),
		Get_Interval_Count(type,1));

	if (VERBOSE && Pvalue < P_CRITERIA)
	    fprintf(out, " *");
	fprintf(out, "\n");
	}
/* ********************************************************************	*/

/* FUNCTION Test_Intervals_Against_Each_Other */
	 /* Test interval 1 (-i) against interval 2 (-I) */
static void Test_Intervals_Against_Each_Other(FILE *out, int stack, int type) {
	float Pvalue;

	if (type == FAIL) {
	   if (! VERBOSE)
	      fprintf(out, "%4d %5.4f    %5.1f %3d\n", stack, 1., 0., 0);
	   return;
	   }

	Pvalue =  Ttest(Get_Interval_Data(type,1),
	          	Get_Interval_Count(type,1),
	          	Get_Interval_Data(type,2),
	          	Get_Interval_Count(type,2),
	          	1),				/* One sided	*/

	fprintf(out, "%4d    %5.4f %5.1f %3d WRONG! INTERVAL LENGTH\n", stack,
	     Pvalue,
	     Get_Interval_Mean(type,1) - Get_Interval_Mean(type,2),
	     Get_Interval_Count(type,1));

	if (VERBOSE && Pvalue < P_CRITERIA)
	    fprintf(out, " *");
	fprintf(out, "\n");
	}
/* ********************************************************************	*/

/* FUNCTION Test_Stacks_Against_Each_Other */
	 /* Test stack 1 against stack 2, using interval 1 */
static void Test_Stacks_Against_Each_Other(FILE *out,
				int stack1, int stack2, int type1, int type2) {
	float  Pvalue;

	if (type1 == FAIL || type2 == FAIL) {
	   if (! VERBOSE)
	      fprintf(out, "%4d %4d %5.4f %5.1f %5.1f %3d\n",
	   				stack1, stack2, 1., 0., 0., 0);
	   return;
	   }

	Pvalue = Ttest(Get_Interval_Data(type1,1),
	               Get_Interval_Count(type1,1),
	               Get_Interval_Data(type2,1),
	               Get_Interval_Count(type2,1),
		       2),				/* Two tailed!	*/

	fprintf(out, " %4d       %4d      %5.4f   %5.1f  %5.1f     %3d", stack1, stack2,
		Pvalue,
		Get_Interval_Mean(type1,1),
		Get_Interval_Mean(type2,1),
		Get_Interval_Count(type2,1));

	if (VERBOSE && Pvalue < P_CRITERIA)
	    fprintf(out, " *");
	fprintf(out, "\n");
	}
/* ********************************************************************	*/
