/* FILE _macros/jeff/getbestclass.c */
     /* Write best class into a file.  If fails, LEAVE EMPTY! */
/* ********************************************************************	*/

#include "../Deffs.h"

/* ********************************************************************	*/

/* FUNCTION GetBestClass105() */
	 /* Write best class number to a file */
void GetBestClass105() {
	FILE *file;
	char Name[80];
	int BestDirection;
	int StackNumber[80];			/* Stacks of interest	*/
		/* Could just use List_Elements(STACK), but extra stacks
		   might be inadvertantly included */
	int StackCount;				/* # interesting stacks	*/
	int i;

	Rewind_InputFile();		/* For consistent unit,run#	*/
   	sprintf(Name, "best_%d.%d", UnitNumber_Header(), RunNumber_Header());
   	file = fopen(Name, (MACRO_APPENDS)?"a":"w");
   	if (file==NULL) {
      	   fprintf(stderr, "Err opening %s", Name);
      	   Exit("", "BestClass105()");
      	   }

	for (i=0; i<List_Length(STACK); i++)	/* Get array of stack #s*/
	   StackNumber[i] = List_Element(i,STACK);
	StackCount = List_Length(STACK);	/* Count the stacks	*/

	/* Find best & null directions, & associated trial types */
	if (List_Length(CLASS) == 1)
	   BestDirection = List_Element(0,CLASS);
	 else
	   BestDirection = Find_Best_Direction_In_Averaged_Stacks(
	   					StackNumber, StackCount);

	if (BestDirection != FAIL)
	   fprintf(file, "%d\n", BestDirection);
	fclose(file);
	}
/* ********************************************************************	*/
