/* FILE _macros/print.c */

#include "../Deffs.h"

/* ********************************************************************	*/
     /* Generic macro: print spike rates in specified interval,
	sorted by stack and class */
     /* Stack name: ounit#.run#
      * First line: unit run begin time end time # stacks # classes # trials
      * Then (for each class):
		 stack, table, body, head, targ, mean, se, n; then indi data
	   NOTE: 1st line gives maximum # of trials; for each class,
		 'n' gives actual # of trials.  Indi data is padded
		 out with 'NAs' to equal the maximum (otherwise would
		 be much more complex to read in data!).
           NOTE: mean is written as Hz; indi data is number of spikes
                 Hz = # spikes / interval
     */

/* ********************************************************************	*/
/* ********************************************************************	*/

/* FUNCTION JeffExportData101 */
	 /* Write individual trial data out for Splus import	*/
	 /* Append any arguments to 'title' to end of file	*/
void JeffExportData101() {
	int Types   = Count_TrialTypes();
	int i;
	FILE *file;
   	char Name[80];

	Rewind_InputFile();		/* For consistent unit,run#	*/
   	sprintf(Name, "o%d.%d", UnitNumber_Header(), RunNumber_Header());
   	file = fopen(Name, (MACRO_APPENDS)?"a":"w");
   	if (file==NULL) {
      	   fprintf(stderr, "Err opening %s", Name);
      	   Exit("", "Write_OutputFiles0()");
      	   }

     	/* First line: unit.run begin(ms) end(ms) stacks classes trials	*/

	fprintf(file,
"Unit\t TrialNo\t TrialType\t Align\t Stack\t Class\t ForInt\t BckInt\t ForSpks\tBckSpks\t Difference\n");
		
	for (i=0; i<Types; i++) {
	    int interval1_count = Get_Interval_Count(i,1);
	    int *interval1_data = Get_Interval_Data(i,1);
	    int *interval2_data = Get_Interval_Data(i,2);
	    int *interval_trialnumber = Get_Interval_TrialNumber(i);
	    int j; 
	    
	    /* Now print spikes in interval for each trial	*/

	    if (Get_Interval_Begin(2) != Get_Interval_End(2))			/* Was interval 2 specified?	*/
	     for (j=0; j<interval1_count; j++)
	      fprintf(file, " %d\t %d\t %s\t %s\t %d\t %d\t %d:%d %d:%d\t %.2f\t %.2f\t %.2f\n",
	      UnitNumber_Header(),
	      *(interval_trialnumber+j),
	      Get_Title_From_CmdLine(), 
	      Get_AlignmentTime(),Get_TrialType_Info(i,STACK), Get_TrialType_Info(i,CLASS),
	      Get_Interval_Begin(1),Get_Interval_End(1),
	      Get_Interval_Begin(2), Get_Interval_End(2), 
	      (*(interval1_data+j) * (1000./ (Get_Interval_End(1) - Get_Interval_Begin(1)))),
	      (*(interval2_data+j) * (1000./ (Get_Interval_End(2) - Get_Interval_Begin(2)))), 
	      ((*(interval1_data+j) * (1000./ (Get_Interval_End(1) - Get_Interval_Begin(1)))) -
	       (*(interval2_data+j) * (1000./ (Get_Interval_End(2) - Get_Interval_Begin(2))))));

	    else							/* No interval 2 */
	     for (j=0; j<interval1_count; j++)
	      fprintf(file, " %d\t %d\t %s\t %s\t %d\t %d\t %d:%d %d:%d\t %.2f\t %.2f\t %.2f\n",
	      UnitNumber_Header(),
	      *(interval_trialnumber+j),
	      Get_Title_From_CmdLine(), 
	      Get_AlignmentTime(),Get_TrialType_Info(i,STACK), Get_TrialType_Info(i,CLASS),
	      Get_Interval_Begin(1),Get_Interval_End(1),
	      Get_Interval_Begin(2), Get_Interval_End(2), 
	      (*(interval1_data+j) * (1000./ (Get_Interval_End(1) - Get_Interval_Begin(1)))),
	      0.,
	      *(interval1_data+j) * (1000./ (Get_Interval_End(1) - Get_Interval_Begin(1))));

	      
	    }


	fclose(file);
	}
/* ********************************************************************	*/
/* ********************************************************************	*/
