/* FILE _macros/jeff/direction.c */
     /* Ttest on directional activity.  Details at end of file. */
/* ********************************************************************	*/

#define STACK_VS_BACKGROUND  		0	/* Do this comparison? */
#define STACK_VS_STACK_BEST_DIRECTION	0	/* Do this comparison? */
#define BEST_VS_NULL			1   	/* Do this comparison? */

#define BEST_DIRECTION_AVERAGED_ACROSS_ALL_STACKS	1
			/* Versus best direction in any single stack */
/* ********************************************************************	*/

#include "../Deffs.h"

/* ********************************************************************	*/

static float correctedP;			/* For multiple compares*/

static int BestDirection;			/* Class w/ peak	*/
static void Test_Against_Zero(FILE *out, int stack, int type);
static void Test_Intervals_Against_Each_Other(FILE *out, int stack, int type);
static void Test_Stacks_Against_Each_Other(FILE *out,
				int stack1, int stack2, int type1, int type2);
/* ********************************************************************	*/

/* FUNCTION TestDirections102 */
	 /* Write individual trial data out for Splus import	*/
	 /* Append any arguments to 'title' to end of file	*/
void TestDirections102() {
	FILE *file;
	char Name[80];
	int StackNumber[80];			/* Stacks of interest	*/
		/* Could just use List_Elements(STACK), but extra stacks
		   might be inadvertantly included */
	int    StackType[80];			/* Stacks of interest	*/
	int OppStackType[80];
	int StackCount = 0;			/* # interesting stacks	*/
	int NullDirection = 0;			/* Class opposite peak	*/
	int BestCueTargEye, BestCueTargArm, BestCueTargTwo;	/* Types*/
	int BestTargCueEye, BestTargCueArm, BestTargCueTwo;
	int NullCueTargEye=FAIL, NullCueTargArm=FAIL, NullCueTargTwo=FAIL;
	int NullTargCueEye=FAIL, NullTargCueArm=FAIL, NullTargCueTwo=FAIL;
	int i;

	Rewind_InputFile();		/* For consistent unit,run#	*/
   	sprintf(Name, "ttest.%d.%d", UnitNumber_Header(), RunNumber_Header());
   	file = fopen(Name, (MACRO_APPENDS)?"a":"w");
   	if (file==NULL) {
      	   fprintf(stderr, "Err opening %s", Name);
      	   Exit("", "TestDirections102()");
      	   }

	fprintf(file, "  Interval: %d to %d ms\n",
					Get_Interval_Begin(1), Get_Interval_End(1)); 
	if (Get_Interval_Type() > 1)
	   fprintf(file, "  Background: %d to %d ms\n",
	   				Get_Interval_Begin(2), Get_Interval_End(2)); 

	fprintf(file, "  P value is %.3f", P_CRITERIA);
	if (List_Length(CLASS) > 1) {
	   correctedP = (float) (1 - pow(1-P_CRITERIA, 1./List_Length(CLASS)));
	   fprintf(file, " (%.4f when corrected for %d comparisons",
	   	correctedP, List_Length(CLASS));
	 } else
	   correctedP = (float) P_CRITERIA;
	fprintf(file, "\n");


	for (i=0; i<List_Length(STACK); i++)	/* Count the stacks	*/
	   switch (List_Element(i,STACK)) {
	      case 200: case 202: case 204:
	      case 210: case 212: case 214:
		   StackNumber[StackCount] = List_Element(i,STACK);
	           StackCount++;
		   break;
	      }

	/* Find best & null directions, & associated trial types */
	BestDirection = 
#	 if BEST_DIRECTION_ACROSS_STACKS
	    Find_Best_Direction_In_Averaged_Stacks(StackNumber, StackCount);
#	 else
	    Find_Best_Direction_Across_Stacks(     StackNumber, StackCount);
#	 endif

	if (BestDirection == FAIL) {
	   if (List_Length(CLASS) == 1)
	      BestDirection = List_Element(0,CLASS);
	   else
	      Exit("Can't find a best direction!", "Test_Directions102()");
	   }

	/* Get various trial types */

	BestCueTargArm = Get_StackClass_TrialType(200, BestDirection);
	BestCueTargEye = Get_StackClass_TrialType(202, BestDirection);
	BestCueTargTwo = Get_StackClass_TrialType(204, BestDirection);

	BestTargCueArm = Get_StackClass_TrialType(210, BestDirection);
	BestTargCueEye = Get_StackClass_TrialType(212, BestDirection);
	BestTargCueTwo = Get_StackClass_TrialType(214, BestDirection);

	NullDirection = Opposite_Class(BestDirection);
	NullCueTargArm = Get_StackClass_TrialType(200, NullDirection);
	NullCueTargEye = Get_StackClass_TrialType(202, NullDirection);
	NullCueTargTwo = Get_StackClass_TrialType(204, NullDirection);
 
	NullTargCueArm = Get_StackClass_TrialType(210, NullDirection);
	NullTargCueEye = Get_StackClass_TrialType(212, NullDirection);
	NullTargCueTwo = Get_StackClass_TrialType(214, NullDirection);

	for (i=0; i<StackCount; i++)		/* Fill data arrays	*/
	   switch (StackNumber[i]) {
	      case 200:    StackType[i] = BestCueTargArm;
			OppStackType[i] = NullCueTargArm;
			break;
	      case 202:    StackType[i] = BestCueTargEye;
			OppStackType[i] = NullCueTargEye;
			break;
	      case 204:    StackType[i] = BestCueTargTwo;
			OppStackType[i] = NullCueTargTwo;
			break;
	      case 210:    StackType[i] = BestTargCueArm;
			OppStackType[i] = NullTargCueArm;
			break;
	      case 212:    StackType[i] = BestTargCueEye;
			OppStackType[i] = NullTargCueEye;
			break;
	      case 214:    StackType[i] = BestTargCueTwo;
			OppStackType[i] = NullTargCueTwo;
			break;
	      }
/* ********************************************************************	*/

	/* Now test if each stack is signif against background	*/
 
  	if (Get_Interval_Type() == 1)  
	   goto SKIP_TESTS_AGAINST_BACKGROUND;

	if (STACK_VS_BACKGROUND){      /*  Do this test? */	
	fprintf(file, "\nIs there a response (vs bg) in individual stacks?\n");
	fprintf(file, " Stack  P-value      mean    n\n");  

	switch (Get_Interval_Type()) {
	   case 2:		/* Is fg firing (-i) diff from bg (-B)?	*/
	   	for (i=0; i<StackCount; i++)
		   Test_Against_Zero(file, StackNumber[i], StackType[i]);
		break;

	   case 3:		/* Is fg firing (-i) diff from bg (-I)?	*/
	   	for (i=0; i<StackCount; i++)
		   Test_Intervals_Against_Each_Other(
		   			file, StackNumber[i], StackType[i]);
		break;
		}
	}	
	
	SKIP_TESTS_AGAINST_BACKGROUND:
/* ********************************************************************	*/

	/* Now, test if each stack is significant against opp direction	*/
	
	if (BEST_VS_NULL){	/* Do this test? */  	
	fprintf(file, "Data    Stack          BestDir  P-value     mean-1  mean-2   n\n");
	for (i=0; i<StackCount; i++)
	   Test_Stacks_Against_Each_Other(	/* Really 2 diff intervals*/
	       		file,
			StackNumber[i], StackNumber[i],
	   		StackType[i], OppStackType[i]);
	}

/* ********************************************************************	*/

	/* Now, test if stacks are different from each other	*/
	      /* Cmp either fg (-i) or fg-bg (-i,-B) intervals		*/

	
	
	if (Get_Interval_Type() == 3) 	/* Not written for -I	*/
	   goto SKIP_THESE_TESTS;

	if (STACK_VS_STACK_BEST_DIRECTION){    /* Do this test? */	
	fprintf(file, "\nAre stacks different from each other (in best direction)?\n");
	fprintf(file, "Data   Stack 1vs2    BestDir   P-value   mean-1  mean-2   n\n");

	if (BestCueTargEye != FAIL && BestCueTargArm != FAIL)
	   Test_Stacks_Against_Each_Other(file, 200, 202,
	   		BestCueTargArm, BestCueTargEye);
	if (BestCueTargTwo != FAIL && BestCueTargArm != FAIL)
	   Test_Stacks_Against_Each_Other(file, 204, 200,
	   		BestCueTargTwo, BestCueTargArm);
	if (BestCueTargTwo != FAIL && BestCueTargEye != FAIL)
	   Test_Stacks_Against_Each_Other(file, 204, 202,
	   		BestCueTargTwo, BestCueTargEye);

	if (BestTargCueEye != FAIL && BestTargCueArm != FAIL)
	   Test_Stacks_Against_Each_Other(file, 210, 212,
	   		BestTargCueArm, BestTargCueEye);
	if (BestTargCueTwo != FAIL && BestTargCueArm != FAIL)
	   Test_Stacks_Against_Each_Other(file, 214, 210,
	   		BestTargCueTwo, BestTargCueArm);
	if (BestTargCueTwo != FAIL && BestTargCueEye != FAIL)
	   Test_Stacks_Against_Each_Other(file, 214, 212,
	   		BestTargCueTwo, BestTargCueEye);

	}

	SKIP_THESE_TESTS:
	/* If interval == 3, then we could make a new array, subtract
	 * -i from -I interval on a trial by trial basis for both stacks,
	 * and then do a ttest of the resultant arrays, stack against
	 * stack.  (In other words, subract the bg from the fg on a
	 * trial by trial basis).
	 */
/* ********************************************************************	*/

	fclose(file);
	}
/* ********************************************************************	*/

/* FUNCTION Test_Against_Zero */
	 /* Test interval 1 (-i minus -B) against zero */
static void Test_Against_Zero(FILE *out, int stack, int type) {
	float Pvalue;

	if (type == FAIL)
	   return;

	Pvalue = Ttest_vs_zero( Get_Interval_Data(type,1),
		       		Get_Interval_Count(type,1),
		       		1),			/* One-sided	*/

	fprintf(out, "%4d    %5.4f    %5.1f %3d",
		stack,
		Pvalue,
		Get_Interval_Mean(type,1),
		Get_Interval_Count(type,1));

	if (Pvalue < correctedP)
	    fprintf(out, " *");
	fprintf(out, "\n");
	}
/* ********************************************************************	*/

/* FUNCTION Test_Intervals_Against_Each_Other */
	 /* Test interval 1 (-i) against interval 2 (-I) */
static void Test_Intervals_Against_Each_Other(FILE *out, int stack, int type) {
	float Pvalue;

	if (type == FAIL)
	   return;

	Pvalue =  Ttest(Get_Interval_Data(type,1),
	          	Get_Interval_Count(type,1),
	          	Get_Interval_Data(type,2),
	          	Get_Interval_Count(type,2),
	          	1),				/* One sided	*/

	fprintf(out, "%4d    %5.4f %5.1f %3d WRONG! INTERVAL LENGTH\n",
	     stack,
	     Pvalue,
	     Get_Interval_Mean(type,1) - Get_Interval_Mean(type,2),
	     Get_Interval_Count(type,1));

	if (Pvalue < correctedP)
	    fprintf(out, " *");
	fprintf(out, "\n");
	}
/* ********************************************************************	*/

/* FUNCTION Test_Stacks_Against_Each_Other */
	 /* Test stack 1 against stack 2, using interval 1 */
static void Test_Stacks_Against_Each_Other(FILE *out,
				int stack1, int stack2, int type1, int type2) {
	float  Pvalue;

	if (type1 == FAIL || type2 == FAIL)
	   return;

	Pvalue = Ttest(Get_Interval_Data(type1,1),
	               Get_Interval_Count(type1,1),
	               Get_Interval_Data(type2,1),
	               Get_Interval_Count(type2,1),
		       2),				/* Two tailed!	*/

	fprintf(out, " %d.%d  %4d   %4d       %d      %5.4f      %5.1f  %5.1f   %3d",
	        UnitNumber_Header(), RunNumber_Header(), stack1, stack2,
		BestDirection, Pvalue,
		Get_Interval_Mean(type1,1),
		Get_Interval_Mean(type2,1),
		Get_Interval_Count(type2,1));

	if (Pvalue < correctedP)
	    fprintf(out, " *");
	fprintf(out, "\n");
	}
/* ********************************************************************	*/

/* MINIMAL DOCUMENTATION: 
 *
 *
 * The direction macro (-o102) performs up to three sets of t tests
 * on data from stacks 200, 202, 204, 210, 212 and 214.
 *
 * 1) Compare foreground to background activity for each stack (only if a
 * background interval is specified).
 *
 * 2) Compare preferred versus null direction firing (foreground activity, or
 * foreground minus background, if background is specified).
 *
 * 3) Compare eye vs arm, eye vs eye+arm and arm vs eye+arm responses in the
 * best direction, separately for cue-target and target-cue experiments.
 * (Uses foreground or foreground minus background data.)
 *
 * Foreground activity is activity in the interval specified by '-i';
 * background activity is activity in the interval specified by '-B'.  Tests
 * using -I are not yet working.
 *
 * In tests 2 and 3, if a background is specified, than comparisons are based
 * on foreground minus background; if only a foreground interval is
 * specified, tests use that interval alone.
 *
 * In tests 2 and 3, if a background is specified, than comparisons are based
 * on foreground minus background; if only a foreground interval is
 * specified, tests use that interval alone.
 *
 * Preferred direction is the direction with the largest
 * response, calculated across all possible classes and stacks; null
 * direction is exactly opposite.
 *
 * The macro should work for single class data (grab -mc), so you could use
 * it instead of macro 100.
 *
 * P value (P_CRITERIA in .grab_config) is corrected for the number of
 * classes.
 *
 */

