/* FILE _macros/util.c */
#include "../Deffs.h"
     /* Some things of generic use to macros */

#define	CAN_RETURN_SECOND_BEST	0	/* If best fails, try 2nd best	*/
/* fine PREF_MINUS_NULL		?	 * usu 1; see ~/.grab_config	*/

/* PUBLIC:
 * MinAndReportDiff	Return lesser of 2 values & report if mismatched
 * Find_Best_Direction_Across_Stacks		What it says!
 * Find_Best_Direction_In_Averaged_Stacks	What it says!
 * Is_A_TrialType_Missing		Class & opp present for all stacks?
 * Opposite_Class			** Assumes a particular coding **
 */
/* ********************************************************************	*/

/* FUNCTION MinAndReportDiff */
	 /* Return min of 2 values, report if diff > 3	*/
int MinAndReportDiff(int a, int b) {
	if ((a<b-3 || b<a-3) && (a<8 && b<8)) {
	   fprintf(stderr, "Note: mismatched counts (%d vs %d)\n", a, b);
	   Warning("");
	   }
	return(Min(a,b));
	}
/* ********************************************************************	*/

/* FUNCTION Find_Best_Direction_Across_Stacks */
	 /* Return class that represents 'best direction' across n stacks */
int Find_Best_Direction_Across_Stacks(int *stacks, int stackcount) {
	   extern float Get_Interval_Mean();
	   float max = -9999.;
	   int i, j;
	   int best_class = Get_dataValue_From_CmdLine();
	   int best_type = 0;

	   if (best_class) {
	      if (Is_A_TrialType_Missing(best_class, stacks, stackcount)) {
		 fprintf(stderr, "Re -d %d:", best_class);
		 Warning("CmdLine -d request is bad");
		 }
	       return(best_class); 		/* But use it anyway	*/
	       }

	   if (PREF_MINUS_NULL && List_Length(CLASS) == 1)
	       Exit("Looking for opp class, but only one class!",
	       "_macro/util.c:Find_Best_Direction_Across_Stacks()");
	      /* Get_StackClass_TrialType gets fooled by a merged class	*/

	   for (i=0; i<Count_TrialTypes(); i++) {  /* Go thru all again	*/
	      int stack = Get_TrialType_Info(i, STACK);

	      for (j=0; j<stackcount; j++)	/* Look at this stack?	*/
	         if (stack == stacks[j])	/*  Yes, look at it	*/
		    break;
	      if (j==stackcount)		/*  No, didn't find it	*/
	         continue;			/*   Try next trial type*/
	          
	      if (PREF_MINUS_NULL == 0)	{	/* Use absolute		*/
	         if (Get_Interval_Mean(i,1) > max)
	             max = Get_Interval_Mean(best_type=i,1);
	      } else {
		 int opp = Get_StackClass_TrialType(	/* Opp re: current */
				stack, Opposite_Class(Get_TrialType_Info(i,CLASS)));

		 if (opp == FAIL)		/* Does opposite exist?	*/
		    continue;			/* If not, skip this one*/
	         if (Get_Interval_Mean(i,1)-Get_Interval_Mean(opp,1) > max)
	            max = Get_Interval_Mean(best_type=i,1) - Get_Interval_Mean(opp,1);
	         }
	      }
	   if (max == -9999.) {
	      fprintf(stderr, "WARNING: can't find best class (1:macros/util.c)");
	      return(FAIL);
	      }

	   best_class = Get_TrialType_Info(best_type, CLASS);

	   if (Is_A_TrialType_Missing(best_class, stacks, stackcount)) {
#	      if CAN_RETURN_SECOND_BEST
	      if (not currently excluding the first best)
	         best_class = Find_Best_Direction_Across_Stacks(best_class);
	      		/* Exclude current best; look for second best */
	      	Exit("Not coded!","_macro/util.c:Find_Best_Direction_Across_Stacks()");
	      if (best_class == FAIL ||
	          Is_A_TrialType_Missing(best_class, stacks, stackcount))
#	      endif
	      fprintf(stderr, "WARNING: trial type missing (1:macros/util.c)\n");
	      return(FAIL);
	      }
	   return(best_class);
	   }
/* ********************************************************************	*/

/* FUNCTION Find_Best_Direction_In_Averaged_Stacks */
	 /* Best class when collapsed across stacks */
int Find_Best_Direction_In_Averaged_Stacks(int *stacks, int stackcount) {
	   extern float Get_Interval_Mean();
	   float max = -9999.;
	   int i;
	   int best_class = Get_dataValue_From_CmdLine();
	   float sums[List_Length(CLASS)];
	   int sum_n[List_Length(CLASS)];

	   if (best_class) {
	      if (Is_A_TrialType_Missing(best_class, stacks, stackcount)) {
		 fprintf(stderr, "Re -d %d:", best_class);
		 Warning("CmdLine -d request is bad");
		 }
	       return(best_class); 		/* But use it anyway	*/
	       }

	   if (PREF_MINUS_NULL && List_Length(CLASS) == 1)
	       Exit("Looking for opp class, but only one class!",
	       "_macro/util.c:Find_Best_Direction_Across_Stacks()");
	      /* Get_StackClass_TrialType gets fooled by a merged class	*/

	   for (i=0; i<List_Length(CLASS); i++) {
	      sums[i] = 0.;
	      sum_n[i] = 0;
	      }

	   /* For each stack of interest, sum responses of all stacks,
	      separating them by class */
	   for (i=0; i<stackcount; i++) {	/* Stacks of interest	*/
	      int Stack = stacks[i];		/* Find this stack	*/
	      int type;

	      /* Look thru types for stacks of interest	*/
	      for (type=0; type<Count_TrialTypes(); type++) {
	        int Class = Get_TrialType_Info(type, CLASS);
		int ListElement = List_Index(Class, CLASS) - 1; /* 0:n-1*/

	        if (Get_TrialType_Info(type, STACK) != Stack)
	           continue;			/* Not stack of interest*/
	       
		Class = Get_TrialType_Info(type,CLASS);	  /* Get class	*/

	        if (PREF_MINUS_NULL) {		/* Subtract opp?	*/
	 	   int opptype = 
		      Get_StackClass_TrialType(Stack, Opposite_Class(Class));
		   if (opptype == FAIL)		/* Does opposite exist?	*/
		      continue;			/* If not, skip this one*/
		   sums[ListElement] -= Get_Interval_Mean(opptype,1);
	           }
	        /* Key stage: add rate, sorted by class	*/
	        sums[ListElement] += Get_Interval_Mean(type,1);
		sum_n[ListElement]++;
		}	/* End of looking for this particular stack	*/
	      }		/* End of looking for all stacks		*/	

	   for (i=0; i<List_Length(CLASS); i++)
	     if ((sums[i] / sum_n[i]) > max) {
	        max = sums[i] / sum_n[i];		/* Index of cla	*/
		best_class = List_Element(i,CLASS);	/* Actual class	*/
		}

	   if (max == -9999.) {
	      fprintf(stderr, "WARNING: can't find best class (2:macros/util.c)");
	      return(FAIL);
	      }

	   if (Is_A_TrialType_Missing(best_class, stacks, stackcount)) {
#	      if CAN_RETURN_SECOND_BEST
	      if (not currently excluding the first best)
	         best_class = Find_Best_Direction_Across_Stacks(best_class);
	      		/* Exclude current best; look for second best */
	      	Exit("Not coded!","_macro/util.c:Find_Best_Direction_Across_Stacks()");
	      if (best_class == FAIL ||
	          Is_A_TrialType_Missing(best_class, stacks, stackcount))
#	      endif
	      fprintf(stderr, "WARNING: trial type missing (2:macros/util.c)\n");
	      return(FAIL);
	      }
	   return(best_class);
	   }
/* ********************************************************************	*/

/* FUNCTION Is_A_TrialType_Missing */
	 /* See if best & null are there for all stacks	*/
int Is_A_TrialType_Missing(int best, int *stacks, int stackcount) {
       int null = Opposite_Class(best);
       int j;

    for (j=0; j<stackcount; j++) {
       if (Get_StackClass_TrialType(stacks[j], best) == FAIL) {
          fprintf(stderr, "Warning: %d.%d is missing\n",stacks[j],best);
          return(1);
	  }
       if (PREF_MINUS_NULL && 
              Get_StackClass_TrialType(stacks[j], null) == FAIL) {
          fprintf(stderr, "Warning: %d.%d is missing\n",stacks[j],null);
          return(1);
	  }
       }
    return(0);					/* No, none are missing	*/
    }
/* ********************************************************************	*/

/* FUNCTION Opposite_Class */
	 /* To get null class */
	 /* NOTE THAT THIS ASSUMES A PARTICULAR CODING SCHEME!! */
int Opposite_Class(int best) {
       return(1 + ((best+3) % 8));
       }
/* ********************************************************************	*/
