/* FILE _macros/ttest.c */

#include "../Deffs.h"

/* ********************************************************************	*/
     /* Generic macros: 

        4: do t-test on spike rates in specified interval;
	     If given two trial types, will compare against each other
	     If given one trial type, will compare against zero

	     If given a background interval (-B), will subtract that interval
		within each trial before doing the T-test.  In other words,
		it will effectively be a paired t-test of foreground vs
		background interval.

	     If given two intervals (-i and -I), and one trial type, will
		compare the two intervals against each other.  Unlike -B,
		the comparison is POOLED, not PAIRED.

	6: do it on eye pos instead of rate
	7: do it on arm pos instead of rate

		(not all the options available for spikes (macro -o4: vs
		 background, etc) are available; if you want them, talk
		to Larry!)
     */

/* ********************************************************************	*/
/* ********************************************************************	*/

/* FUNCTION Ttest_macro4() */
	 /* ttest on SPIKE RATE */
	 /* Write individual trial data out for Splus import	*/
	 /* Append any arguments to 'title' to end of file	*/
void Ttest_macro4() {
	int Types   = Count_TrialTypes();
	int First=0, Second=1;

	if (Types > 2) {
	   fprintf(stderr, "Give no more than two types (not %d)\n", Types);
	   return;
	   }

	if (Types == 1) {
	    fprintf((MACRO_APPENDS==2) ? stdout:stderr, 
	    "%d.%d: Two-tailed t-test on %d.%d ",
	     UnitNumber_Header(), RunNumber_Header(),
	     Get_TrialType_Info(First, STACK), Get_TrialType_Info(First,CLASS));

	   if (Get_Interval_Type() == 3) {   /* -i and -I specified?	*/
	     fprintf((MACRO_APPENDS==2) ? stdout:stderr, 
		"(interval 1 vs 2): means %.2f vs %.2f  P= %.4f\n",
	       Get_Interval_Mean(First, 1),		/* Interval 1, mean*/
	       Get_Interval_Mean(First, 2),		/* Interval 2, mean*/
	       Ttest_On_Two_Intervals(First, 2));	/* type, sides	*/
	    } else {
	     fprintf((MACRO_APPENDS==2) ? stdout:stderr, 
	     	"(versus 0): mean %.2f P= %.4f\n",
	       Get_Interval_Mean(First, 1),		/* Interval 1, mean*/
	       Ttest_Vs_Zero_On_Interval(1, First, 2));	/* Int 1, 2 tails  */
	     }
	   return;
	   }
	 
	if (Get_Interval_Type() == 3) {   /* -i and -I specified?	*/
	   fprintf(stderr, "If you give 2 intervals, don't give 2 types!\n");
	   fprintf(stderr,
"(To subtract background firing before doing a t-test, use -B, not -I.\n");
	   fprintf(stderr,
"However, I DO NOT RECOMMEND SUBTRACTING BASELINES BEFORE COMPARING!!!!)\n");
	   return;
	   }	   


	if (Get_TrialType_Info(0,STACK) > Get_TrialType_Info(1,STACK)) {
	   First = 1;
	   Second = 0;
         } else if (Get_TrialType_Info(0,STACK) == Get_TrialType_Info(1,STACK))
	   if (Get_TrialType_Info(0,CLASS) > Get_TrialType_Info(1,CLASS)) {
	      First = 1;
	      Second = 0;
	      }

	fprintf((MACRO_APPENDS==2) ? stdout:stderr, 
"%d.%d: Two-tailed t-test on %d.%d versus %d.%d: means %.2f vs %.2f P= %.4f\n",
	   UnitNumber_Header(), RunNumber_Header(),
	   Get_TrialType_Info(First, STACK), Get_TrialType_Info(First, CLASS),
	   Get_TrialType_Info(Second, STACK), Get_TrialType_Info(Second, CLASS),
	   Get_Interval_Mean(First, 1),		     /* Interval 1, mean*/
	   Get_Interval_Mean(Second, 1),	     /* Interval 1, mean*/
	   Ttest_On_Interval(1, First, Second, 2));  /* Int 1, 2 tails 	*/
	}
/* ********************************************************************	*/

/* FUNCTION Ttest_macro6() */
	 /* ttest on BEHAVIOR */
	 /* Write individual trial data out for Splus import	*/
	 /* Append any arguments to 'title' to end of file	*/
void Ttest_macro6() {
#	define MAX_TO_TTEST	5000
	int Types   = Count_TrialTypes();
	int EyeH[2][MAX_TO_TTEST];
	int EyeV[2][MAX_TO_TTEST];
	int ArmH[2][MAX_TO_TTEST];
	int ArmV[2][MAX_TO_TTEST];
	
	int CountEye[2] = {0,0};
	int CountArm[2] = {0,0};

	int i, j;

	if (Types != 2) {
	   fprintf(stderr, "Must give exactly two types (not %d)\n", Types);
	   return;
	   }

	for (i=0; i<MAX_TO_TTEST; i++)
	 for (j=0; j<2; j++)
	   EyeH[j][i] =
	   EyeV[j][i] =
	   ArmH[j][i] =
	   ArmV[j][i] = 0;

	Rewind_InputFile();		/* For consistent unit,run#	*/

	/* Loop thru data: */
	while (Read_Next_Trial(WITH_DATA)) {
	   float x,y,X,Y;
	   int type = Get_TrialType();

	   Get_EyePosition(Get_Interval_Begin(1), Get_Interval_End(1), &X, &Y);
	   Get_ArmPosition(Get_Interval_Begin(1), Get_Interval_End(1), &x, &y);

	   if (Get_Interval_Begin(2) != Get_Interval_End(2)) {
	      float x2,y2,X2,Y2;

	      Get_EyePosition(Get_Interval_Begin(2),
	      		      Get_Interval_End(2), &X2, &Y2);
	      Get_ArmPosition(Get_Interval_Begin(2),
	      		      Get_Interval_End(2), &x2, &y2);
	      X -= X2;
	      Y -= Y2;

	      if (x==FAIL || y==FAIL || x2==FAIL || y2==FAIL)
	         x = y = FAIL;
	      else {
	         x -= x2;
	         y -= y2;
		 }
	      }

	   EyeH[type][CountEye[type]] = 100*X;	/* int w/o precision loss */
	   EyeV[type][CountEye[type]] = 100*Y;
	   CountEye[type]++;

	   if (CountEye[type] >= MAX_TO_TTEST)
	      Exit("Too many trials!", "TtestMacro6");

	   if (x != FAIL) {
	    ArmH[type][CountArm[type]] = 100*x;
	    ArmV[type][CountArm[type]] = 100*y;
	    CountArm[type]++;
	    }
	   }

	fprintf((MACRO_APPENDS==2) ? stdout:stderr, 
	   "%d.%d: Two-tailed t-test on %d.%d versus %d.%d\n",
	   UnitNumber_Header(), RunNumber_Header(),
	   Get_TrialType_Info(0, STACK), Get_TrialType_Info(0, CLASS),
	   Get_TrialType_Info(1, STACK), Get_TrialType_Info(1, CLASS));

	fprintf((MACRO_APPENDS==2) ? stdout:stderr, 
	   "   Interval %d to %d\n",
		Get_Interval_Begin(1), Get_Interval_End(1));

	if (Get_Interval_Begin(2) == Get_Interval_End(2))
	   fprintf((MACRO_APPENDS==2) ? stdout:stderr, 
	      "   Interval2 %d to %d\n",
		Get_Interval_Begin(2), Get_Interval_End(2));

	fprintf((MACRO_APPENDS==2) ? stdout:stderr, 
	   "\n");

	fprintf((MACRO_APPENDS==2) ? stdout:stderr, 
	   " H eye: %.4f\n",		/* 2-tail T's	*/
	   Ttest(EyeH[0], CountEye[0], EyeH[1], CountEye[1], 2));
	fprintf((MACRO_APPENDS==2) ? stdout:stderr, 
	   " V eye: %.4f\n",
	   Ttest(EyeV[0], CountEye[0], EyeV[1], CountEye[1], 2));
	fprintf((MACRO_APPENDS==2) ? stdout:stderr, 
	   " H arm: %.4f\n",
	   Ttest(ArmH[0], CountArm[0], ArmH[1], CountArm[1], 2));
	fprintf((MACRO_APPENDS==2) ? stdout:stderr, 
	   " V arm: %.4f\n",
	   Ttest(ArmV[0], CountArm[0], ArmV[1], CountArm[1], 2));
	}
/* ********************************************************************	*/
