/* FILE _macro/touch2.c */
	/* Get data from the EITHER touch panel (-D1: panel 1)	*/
	/* ALIGN ON 'GO' !!					*/

#include "../Deffs.h"
#include "../../deffs.h"

#include "../../event.h"				/* V_SYNC	*/
/* ********************************************************************	*/

#define PARAMETERS	10			/* Parameters per trial	*/
		/* Print additional info about each trial (timing, etc)	*/

static char Name[80];				/* Trajectory file name	*/
/* ********************************************************************	*/

void GetTrajectory162() {
	/* Get data from the EITHER touch panel (-D1: panel 1)	*/
	/* ALIGN ON 'GO' !!					*/
	/* Calls standard macro, then calls Matt's script to read it
	 * back in (!) and then outputs a version that has 100 data points
	 * spaced along the movement trajectory. */
	char Call[180];

        PrintTouches161();
	sprintf(Call, 
	 "/data/code/grab/2009.washu/_macros/generic/getTrajectory.sh \"'%s'\"",
	 Name);
	system(Call);
	}
/* ********************************************************************	*/

void PrintTouches161() {
	/* Get data from the EITHER touch panel (-D1: panel 1)	*/
	/* ALIGN ON 'GO' !!					*/
	int max_touches = 0;
	int trials = 0;
	FILE *file;
	int sac_start;
	int sac_end;
	int limb_start;
	int limb_end;
	int limb_acquire;
	int Board = (Get_DataValue_From_CmdLine() == 1) ? 1: 2;


	Rewind_InputFile();		/* For consistent unit,run#	*/
   	sprintf(Name, "Trajectory_%d.%d",
		UnitNumber_Header(), RunNumber_Header());
   	file = fopen(Name, (MACRO_APPENDS)?"a":"w");
   	if (file==NULL) {
      	   fprintf(stderr, "Err opening %s", Name);
      	   Exit("", "Print_touches161()");
      	   }

	/* Loop thru data and find max # of touches */
	while (Read_Next_Trial(WITH_DATA)) {
	   if (TouchCount_Header(Board) > max_touches)
	      max_touches = TouchCount_Header(Board);
	   trials++;
	   }

	fprintf(file, "%d %d %d\n\n", trials, max_touches, PARAMETERS);
		/* Easiest if parameters is a multiple of three/five!!	*/

	Rewind_InputFile();		/* For consistent unit,run#	*/
	while (Read_Next_Trial(WITH_DATA)) {
	   extern ARMDATA ArmData2[];
	   extern ARMDATA ArmData1[];
           ARMDATA *ptr = (Board==2) ? ArmData2 : ArmData1;
	   int count  = TouchCount_Header(Board);
	   int GoTime = Interval_To_Stack_Time(0);      /* 'Go' signal  */
	   int dist = Get_ViewingDistance_Header();
	   int j;

	   { int vsync = EventExtract(V_SYNC, TIME, 2);	/* Sync off     */
	     if (vsync != FAIL) {
	       if (vsync - GoTime > 40 || vsync < GoTime)
		 Exit("Wierd V_SYNC event!","latency.c, ExtractAndStoreTimes");
	       GoTime = vsync;
	       }
	    }

	   					/* Get sac,limb data   */
	   extern int Get_Saccade_Quietly;		/* sac.c	*/
	   Get_Saccade_Quietly = 1;
	   sac_start = Get_Saccade_Time(1, 1, GoTime-50, 0);
	   sac_end =   Get_Saccade_Time(0, 1, GoTime-50, 0);
	   limb_start = Get_Arm_Move_Time(GoTime, 0);
#	   ifdef TRY_TO_CATCH_ERRORS
	   if (limb_start + 50 < sac_start) {	/* Reach >50 ms BEFORE sac?*/
	      fprintf(stderr, "Unlikely: Go at %d; sac %d to %d  reach %d  try again\n", GoTime, sac_start, sac_end, limb_start);
	      limb_start = Get_Arm_Move_Time(GoTime+150, 0);
	      fprintf(stderr, "  New reach start: %d\n", limb_start);
	      }
#	   endif
	   limb_end   = Get_Arm_Stop_Time(limb_start+150, 0);
	   if (limb_end < limb_start)	/* Occasional bad result!	*/
	       limb_end   = Get_Arm_Stop_Time(limb_start+300, 0);
	   /* if (limb_end == FAIL) Warning("Limb_end returns 'fail'"); */
	   limb_acquire = AcquireEventExtract(ARM, -1, TIME, 2);


	   /* PRINT OUT THE 'PARAMETERS'				*/
	   fprintf(file, "%d %d %d   %d %d   %d %d  %d    %d",
		StackNumber_Header(), TableNumber_Header(), count,
		sac_start,sac_end, limb_start,limb_end, limb_acquire, GoTime);

	   fprintf(file, "  0\n");

#  	   define RADStoDEG(x)    ((x) * 360 / (2 * 3.14159))
#          define H_CALIB(x) RADStoDEG(atan((double) x * (6.75/4) / dist))
#          define V_CALIB(x) RADStoDEG(atan((double) x * (6.75/4) / dist))
	   if (dist == 0)				/* Don't have?	*/
	      dist = (Get_SetupNumber_Header() == 1) ? 160 : 130;

	   for (j=0; j<count; j++, ptr++) {
	      fprintf(file, "%9d %4d %4d  %3.1f %3.1f",
			     		/* Board 1:input.c -= SpikeTime	*/
			(Board==2) ? ptr->time : ptr->time + SkipSpikeTime(), 
			ptr->h, ptr->v,			   /* +/- beam	*/
			H_CALIB(ptr->h), V_CALIB(ptr->v)); /* degrees	*/
	      if (j % 4 == 3)
	         fprintf(file, "\n");
	      }

	   if (j<max_touches && (j % 4 != 0))
	      fprintf(file, "\n");
	   for (; j<max_touches; j++)
	      fprintf(file, "NA NA NA NA NA ");
	      /* fprintf(file, "%5d %4d %4d     ", 0, 0, 0); */
	   fprintf(file, "\n\n");
	   }
	fclose(file);
	}
/* ********************************************************************	*/
/* ********************************************************************	*/
