/* FILE _macros/targets.c */

#include "../Deffs.h"

/* ********************************************************************	*/
     /* Generic macro: print times & locations of targets, trial by trial
      *    unit run trial# 
      *	      then for each target:  on.time off.time h v
      *    Use '-d' to say how many targets to report on; default is 3
      *    Use '-D' to say how many trials to report on; default is all
      *    	(Redundant with "-X", but if you exclude a class/stack,
      *    	 then it might not do what you want.  E.g., if want 1st
      *    	 instance of class #1, then "-Xc1 -X1" will return nothing
      *    	 if the very first trial in the file is not class 1!
      *    Times are stack times (ms), locations in tenth degrees
      */

/* ********************************************************************	*/
/* ********************************************************************	*/

/* FUNCTION Write_Targets */
	 /* Write individual trial data out for Splus import	*/
void Write_Targets8() {
	FILE *file;
   	char Name[80];
	int MaxTries = 3;
	int Trials = -1;
	int try;

	if (Get_dataValue_From_CmdLine())
	    MaxTries = Get_dataValue_From_CmdLine();

	if (Get_DataValue_From_CmdLine())
	    Trials = Get_DataValue_From_CmdLine();

	Rewind_InputFile();		/* For consistent unit,run#	*/

   	sprintf(Name, "Targets_%d.%d",
		UnitNumber_Header(), RunNumber_Header());
   	file = Open_Macro_Output(Name, -1);

	fprintf(file, "%d %d\n",
	   	UnitNumber_Header(), RunNumber_Header());

	/* Loop thru data: */
	while (Read_Next_Trial(WITH_DATA)) {
	   if (--Trials == -1)		/* Only a fixed # of trials	*/
	      break;
	   fprintf(file, "%d ", TrialNumber_Input());
	   for (try=1; try<=MaxTries; try++) {
	      int TargetNumber = AnyTargetEventExtract(ONE, try);
	      int TargetOnTime   = AnyTargetEventExtract(TIME, try);
	      int i;

	      for (i=1; i<10; i++)
	        if (TargetOffEventExtract(TargetNumber, TIME, i) > TargetOnTime)
		   break;
	      if (i==10) i=50;	/* Be sure TargOffEvExt returns a fail */

	      fprintf(file, "%d %d %d %d %d %d ",
	   	TargetOnTime,
		(TargetNumber != FAIL) ?
		   TargetOffEventExtract(TargetNumber, TIME, i) : FAIL,
		AnyTargetEventExtract(TYPE, try),	/* Added 6-2012	*/
		AnyTargetEventExtract(ONE, try),	/* Added 6-2012	*/
	   	AnyTargetEventExtract(TWO, try),
	   	AnyTargetEventExtract(THREE, try));
	      }
	   fprintf(file, "\n");
	   }

	fclose(file);
	}
/* ********************************************************************	*/
