/* FILE _macros/saccades.c */

#include "../Deffs.h"

#include "../../event.h"
/* ********************************************************************	*/

/* FUNCTION Saccades155 */
	 /* List all saccades */
void Saccades155() {
	FILE *file;
	char Name[80];
	int  RunNumber;		/* Run number may change	*/
	extern float SacPeakVelocity_H, SacPeakVelocity_V;
	extern float SacPosition_H, SacPosition_V;

	extern int Get_Saccade_Limited;
	extern int Get_Saccade_Stringent;

	Get_Saccade_Limited = 0;		/* Don't stop looking!	*/
	Get_Saccade_Stringent = 1;		/* Find *all* saccades!	*/

	Rewind_InputFile();

	sprintf(Name, "Saccades.s%d.%d.out",
		UnitNumber_Header(), RunNumber_Header());
	file = fopen(Name, (MACRO_APPENDS)?"a":"w");
	if (file==NULL) {
		fprintf(stderr, "Err opening %s", Name);
		Exit("", "Saccades155()");
		}

	Read_Next_Trial(SKIP_DATA);		/* Get 1st header	*/
	RunNumber = RunNumber_Header();		/* Same thru-out file?	*/
	Rewind_InputFile();			/* Back to start	*/

	while (Read_Next_Trial(WITH_DATA)) {
	   int trial = TrialNumber_Header();		/* Trial #	*/
	   int time = EventExtract(TAPE_ON, TIME, 1) + 5;
	   int sac_start = -FAIL * 2;
	   int none = 1;

	   while ((sac_start = Get_Saccade_Time(1,1,time,0)) != FAIL) {
	    float Start_H = SacPosition_H;	/* Set by Get_Sac_Time	*/
	    float Start_V = SacPosition_V;
	   					/* Get sac end data 	*/
	    int sac_end = Get_Saccade_Time(0, 1, time, 0);
	    float End_H = SacPosition_H;	/* Set by Get_Sac_Time	*/
	    float End_V = SacPosition_V;	/* Now set peakvel vars:*/
	    int peaktime = Get_Saccade_Peak_Velocity(1, time, 0);
	   	/* Unsed variable, but need call to set peak velocity	*/
	   					/* Get limb data	*/

	   fprintf(file, "%d   %d %d %d  %d  %.2f %.2f  %.2f %.2f %d %d\n",
		 TrialNumber_Input(),
		 trial,	/* Make trial# unambig	*/
	   	 StackNumber_Header(),
		 TableNumber_Header(),
		 sac_end - sac_start,			/* Sac duration	*/
		 End_H-Start_H,				/* Sac amplitude*/
		 End_V-Start_V,
		 SacPeakVelocity_H,			/* Sac velocity	*/
		 SacPeakVelocity_V,
		 sac_start - Interval_To_Stack_Time(0),	/* Start time	*/
		 peaktime -Interval_To_Stack_Time(0));	/* peak vel time*/
	   time = sac_end + 50;
	   none = 0;
	   }

	if (none)
	   fprintf(file, "%d   %d %d %d        0 0 0 0 0 0 0\n",
		 TrialNumber_Input(),
		 trial,
	   	 StackNumber_Header(),
		 TableNumber_Header());
	}
	fclose(file);
	}
/* ********************************************************************	*/
