/* FILE _macros/printbehav.c */

#include "../Deffs.h"

/* ********************************************************************	*/
     /* Generic macro: print EYE and ARM positions in specified interval,
	sorted by stack and class */
     /* Stack name: BehavMean_unit#.run# */
     /* For each type: stack class eye-h eye-v arm-h arm-v #trials */

     /* Second version is terse (Print_Behav9) */

/* ********************************************************************	*/
/* ********************************************************************	*/

void Print_Behav5() {
	int Types   = Count_TrialTypes();
	int type;
	FILE *file;
   	char Name[80];
	int s,c;

	float Sum_H_Eye[MAX_TYPES];
	float Sum_V_Eye[MAX_TYPES];
	float Sum_H_Arm[MAX_TYPES];
	float Sum_V_Arm[MAX_TYPES];

	float Sum2_H_Eye[MAX_TYPES];
	float Sum2_V_Eye[MAX_TYPES];
	float Sum2_H_Arm[MAX_TYPES];
	float Sum2_V_Arm[MAX_TYPES];

	int Count_Arm[MAX_TYPES];
	int Count_Eye[MAX_TYPES];

	for (type=0; type<Types; type++) {
	   Sum_H_Eye[type] =
	   Sum_V_Eye[type] =
	   Sum_H_Arm[type] =
	   Sum_V_Arm[type] = 0.0;
	   Sum2_H_Eye[type] =
	   Sum2_V_Eye[type] =
	   Sum2_H_Arm[type] =
	   Sum2_V_Arm[type] = 0.0;
	   Count_Eye[type] = Count_Arm[type] = 0;
	   }

	Rewind_InputFile();		/* For consistent unit,run#	*/
   	sprintf(Name, "BehavMean_%d.%d",
		UnitNumber_Header(), RunNumber_Header());
   	file = fopen(Name, (MACRO_APPENDS)?"a":"w");
   	if (file==NULL) {
      	   fprintf(stderr, "Err opening %s", Name);
      	   Exit("", "Write_OutputFiles0()");
      	   }

	/* Loop thru data: */
	while (Read_Next_Trial(WITH_DATA)) {
	   float x,y,X,Y;

	   int type = Get_TrialType();

	   Get_EyePosition(Get_Interval_Begin(1), Get_Interval_End(1), &X, &Y);
	   Get_ArmPosition(Get_Interval_Begin(1), Get_Interval_End(1), &x, &y);

	   if (Get_Interval_Begin(2) != Get_Interval_End(2)) {
	      float x2,y2,X2,Y2;

	      Get_EyePosition(Get_Interval_Begin(2),
	      		      Get_Interval_End(2), &X2, &Y2);
	      Get_ArmPosition(Get_Interval_Begin(2),
	      		      Get_Interval_End(2), &x2, &y2);
	      X -= X2;
	      Y -= Y2;
	      if (x==FAIL || y==FAIL || x2==FAIL || y2==FAIL)
	         x = FAIL;
	      else {
	         x -= x2;
	         y -= y2;
		 }
	      }

	   Sum_H_Eye[type]  += X;
	   Sum_V_Eye[type]  += Y;
	   Sum2_H_Eye[type] += X*X;
	   Sum2_V_Eye[type] += Y*Y;
	   Count_Eye[type]++;

	   if (x != FAIL) {
	      Sum_H_Arm[type]  += x;
	      Sum_V_Arm[type]  += y;
	      Sum2_H_Arm[type] += x*x;
	      Sum2_V_Arm[type] += y*y;
	      Count_Arm[type]++;
	      }

	   }

	fprintf(file, "***  Unit %d run %d   %d to %d ms",
		UnitNumber_Header(), RunNumber_Header(),
		Get_Interval_Begin(1), Get_Interval_End(1));
	if (Get_Interval_Begin(2) != Get_Interval_End(2))
	   fprintf(file, "  vs %d to %d ms",
		Get_Interval_Begin(2), Get_Interval_End(2));
	fprintf(file, "    %s ***\n", AlignTime_String());
	fprintf(file, " stk.cls  eye-h  SE     eye-v  SE           arm-h  SE     arm-v  SE      N\n");

	for (s=0; s<List_Length(STACK); s++)
	 for (c=0; c<List_Length(CLASS); c++) {
	    int i = Get_StackClass_TrialType(
		List_Element(s,STACK), List_Element(c,CLASS));
	    if (i == FAIL)
	       continue;
	    fprintf(file, " %d.%d\t%6.2f%6.2f  %6.2f%6.2f\t  ",
		List_Element(s,STACK), List_Element(c,CLASS),
		Sum_H_Eye[i]/Count_Eye[i], 
		SE( Sum_H_Eye[i], Sum2_H_Eye[i], Count_Eye[i]),
		Sum_V_Eye[i]/Count_Eye[i],
		SE( Sum_V_Eye[i], Sum2_V_Eye[i], Count_Eye[i]));
	    if ((Sum_H_Arm[i]/Count_Arm[i]) != -500)
	     fprintf(file, "%6.1f%6.1f %6.1f%6.1f  ",
		Sum_H_Arm[i]/Count_Arm[i],
		SE( Sum_H_Arm[i], Sum2_H_Arm[i], Count_Arm[i]),
 	 	Sum_V_Arm[i]/Count_Arm[i],
		SE( Sum_V_Arm[i], Sum2_V_Arm[i], Count_Arm[i]));
	    fprintf(file, "\t%d\n", Count_Eye[i]);
	    }

	if (Types == 2)
	    fprintf(file, "\t P=\t%.4f\t\t%.4f\t\t%.4f\t%.4f\n",
	      Ttest_short(
		Sum_H_Eye[0]/Count_Eye[0], 
		Count_Eye[0],
		SE( Sum_H_Eye[0], Sum2_H_Eye[0], Count_Eye[0]),
		Sum_H_Eye[1]/Count_Eye[1], 
		Count_Eye[1],
		SE( Sum_H_Eye[1], Sum2_H_Eye[1], Count_Eye[1]),
		2), /* 2 tails */
	      Ttest_short(
		Sum_V_Eye[0]/Count_Eye[0], 
		Count_Eye[0],
		SE( Sum_V_Eye[0], Sum2_V_Eye[0], Count_Eye[0]),
		Sum_V_Eye[1]/Count_Eye[1], 
		Count_Eye[1],
		SE( Sum_V_Eye[1], Sum2_V_Eye[1], Count_Eye[1]),
		2), /* 2 tails */
	      Ttest_short(
		Sum_H_Arm[0]/Count_Arm[0], 
		Count_Arm[0],
		SE( Sum_H_Arm[0], Sum2_H_Arm[0], Count_Arm[0]),
		Sum_H_Arm[1]/Count_Arm[1], 
		Count_Arm[1],
		SE( Sum_H_Arm[1], Sum2_H_Arm[1], Count_Arm[1]),
		2),
	      Ttest_short(
		Sum_V_Arm[0]/Count_Arm[0], 
		Count_Arm[0],
		SE( Sum_V_Arm[0], Sum2_V_Arm[0], Count_Arm[0]),
		Sum_V_Arm[1]/Count_Arm[1], 
		Count_Arm[1],
		SE( Sum_V_Arm[1], Sum2_V_Arm[1], Count_Arm[1]),
		2));
	fclose(file);
	}
/* ********************************************************************	*/

void Print_Behav9() {
	FILE *file;
	int SecondInterval = Get_Interval_Type() > 1;	
						/* Was there a -I or -B?*/

	Rewind_InputFile();		/* For consistent unit,run#	*/
    	file = Open_Macro_Output("BehavIndi", -1);
   	if (file==NULL)
      	   Exit("Err opening BehavIndi", "Write_OutputFiles0()");

	fprintf(file, "%d %d\n", UnitNumber_Header(), RunNumber_Header());

	/* Loop thru data: */
	while (Read_Next_Trial(WITH_DATA)) {
	   float x, y, X, Y;
	   Get_EyePosition(Get_Interval_Begin(1), Get_Interval_End(1), &x, &y);
	   if (SecondInterval) {
	    Get_EyePosition(Get_Interval_Begin(2),Get_Interval_End(2),&X,&Y);
	    fprintf(file, "%d %.2f %.2f  %.2f %.2f  ",
	   	TrialNumber_Header(), x, y, X, Y);
	   } else
	    fprintf(file, "%d %.2f %.2f  ",TrialNumber_Header(), x, y);
	   /* Changed from TrialNumber_Input() to ...Header(), 5-2011 LHS */


	   Get_ArmPosition(Get_Interval_Begin(1), Get_Interval_End(1), &x, &y);
	   if (SecondInterval) {
	    Get_ArmPosition(Get_Interval_Begin(2), Get_Interval_End(2), &X, &Y);
	    fprintf(file, "%.2f %.2f  %.2f %.2f", x, y, X, Y);
	   } else
	    fprintf(file, "%.2f %.2f  ",x, y);

	   fprintf(file, "\n");
	   }
	}
/* ********************************************************************	*/
