/* FILE _macros/interval.c */

#include "../Deffs.h"

/* ********************************************************************	*/
     /* Stack name: unit#.run#
      * First line:
      * unit run begin.time end.time begin2 end2 #.stacks #.classes #.trials
      * Then (for each class):
		 unit, stack, class, trialcount, then
		 	spikes/trial, padded with NA to some maximum.
     */

/* ********************************************************************	*/
#define PAD_TO_MAXIMUM	16		/* Always give this many trials	*/

void Interval7() {
	int Types   = Count_TrialTypes();
	int i;
	FILE *file;
   	char Name[60];

	Rewind_InputFile();		/* For consistent unit,run#	*/
   	sprintf(Name, "o%d.%d", UnitNumber_Header(), RunNumber_Header());
   	file = fopen(Name, (MACRO_APPENDS)?"a":"w");
   	if (file==NULL) {
      	   fprintf(stderr, "Err opening %s", Name);
      	   Exit("", "Write_OutputFiles0()");
      	   }

     	/* First line: unit.run begin(ms) end(ms) stacks classes trials	*/
	fprintf(file, "%d.%d %d %d %d %d %d %d\n",
   		UnitNumber_Header(), RunNumber_Header(),
		List_Length(STACK), List_Length(CLASS),
		Get_Interval_Begin(1), Get_Interval_End(1),
		Get_Interval_Begin(2), Get_Interval_End(2)
		);
	for (i=0; i<Types; i++) {
	    int count = Get_Interval_Count(i,1);
	    int *data = Get_Interval_Data(i,1);
	    int j;
	    fprintf(file, "%d %2d %2d ",
		Get_TrialType_Info(i,STACK), 
		Get_TrialType_Info(i,CLASS),
		count);

	    if (PAD_TO_MAXIMUM && count > PAD_TO_MAXIMUM) {
		fprintf(stderr, "Too many trials (%d); truncating to %d\n",
			count, PAD_TO_MAXIMUM);
	        count = PAD_TO_MAXIMUM;
		}
	
	    /* Now print spikes in interval for each trial	*/
	    for (j=0; j<count; j++)
	       fprintf(file, " %d", *(data+j));
	    if (PAD_TO_MAXIMUM)
	       while (j++ < PAD_TO_MAXIMUM)
	          fprintf(file, " NA");
		 
	    fprintf(file, "\n");
	    }

	fclose(file);
	}
/* ********************************************************************	*/
