/* FILE _macros/bounds.c */

#include "../Deffs.h"
#include "../../event.h"

/* ********************************************************************	*/

/* FUNCTION Check_Bounds150 */
	 /* Report which trials lack data in the specified interval	*/
void Check_Bounds150() {
	int Begin = Get_Interval_Begin(1);
	int End = Get_Interval_End(1);

	Rewind_InputFile();
	while (Read_Next_Trial(WITH_DATA)) {
	   int Align = Get_AlignTime();
	   int TapeOn = EventExtract(TAPE_ON, TIME, 1);
	   int TapeOff = EventExtract(TAPE_OFF, TIME, 1);

	   if (TapeOn - Align > Begin || TapeOff - Align < End)
		fprintf(stderr, "%d %d %d\n",
			TrialNumber_Input(), TapeOn-Align, TapeOff-Align);
	   }
	}
/* ********************************************************************	*/
