/* FILE _macros/anova */
     /* Compute one-way anova on whatever is passed to us */
     /* Compute two-way anova on stacks X classes	*/

#include "../Deffs.h"

#include <stdlib.h>					/* system()	*/
/* ********************************************************************	*/
     /* Generic macros: 

        144: do anova on spike rates in specified interval
        146: do 2-way anova on spike rates in specified interval, stacks x classes
     */

/* ********************************************************************	*/
/* ********************************************************************	*/

/* FUNCTION Anova_macro144() */
	 /* anova on SPIKE RATE */
void Anova_macro144() {
	int Types   = Count_TrialTypes();
	int i;

	fprintf(stderr, "Buggy, esp 2 classes?\n");
	fprintf(stderr, "May be non-parametric!  (See anova.c)\n");

	if (Types < 2) {
	   fprintf(stderr, "Need at least 2 types (not %d)\n", Types);
	   return;
	   }

	fprintf(stderr, "%d.%d", UnitNumber_Header(), RunNumber_Header());

	if (Types > 3)
	   fprintf(stderr, "\n");

	for (i=0; i<Types; i++)
	   fprintf(stderr, " %s%3d.%d", 
		((Get_TrialType_Info(i, CLASS) < 10) ? " " : ""), /*Align*/
	   	Get_TrialType_Info(i, STACK), Get_TrialType_Info(i, CLASS));

	if (Types > 3)
	   fprintf(stderr, "\n");

	for (i=0; i<Types; i++)
	   fprintf(stderr, " %6.1f", Get_Interval_Mean(i, 1));

	if (Types > 3)
	   fprintf(stderr, "\n");

	fprintf(stderr, "   %.4f\n", Anova_On_Interval());
	}
/* ********************************************************************	*/
/* ********************************************************************	*/

/* FUNCTION TwoWayAnova_macro146() */
	 /* Call 'R' and do a two-way anova */
void TwoWayAnova_macro146() {
	FILE *input, *output;

	Rewind_InputFile();
	input = fopen("anova.input", (MACRO_APPENDS)?"a":"w");

	while (Read_Next_Trial(WITH_DATA))
           fprintf(input, "%d %d %d\n",
	     StackNumber_Header(),
	     TableNumber_Header(),
	     Spikes_In_Interval(1));

	fclose(input);

       system("R --vanilla -q --slave < /data/code/grab/washu/_macros/generic/anova.code.r > anova.output");

	output = fopen("anova.output", "r");
	  { float stackP, classP, interactP;
	  fscanf(output, "%f %f %f", &stackP, &classP, &interactP);
	  fprintf(stderr, "%.3f %.3f %.3f\n", stackP, classP, interactP);
	  system("rm anova.output anova.input");	/* Clean up	*/
	  }
	} 
/* ********************************************************************	*/
