/* FILE write_sac.c */
     /* Macros 84, 85, 86 */
/* ********************************************************************	*/

#include "../Deffs.h"
#include "../../event.h"
/* ********************************************************************	*/

void Write_SacEndpts84() {
	FILE *file;
	char Name[80];
	int begin = Get_Interval_Begin(1);
	int end = Get_Interval_End(1);
	int  RunNumber;		/* Run number may change	*/
	int  SequentialRun = 0;	/* Count runs, chg TrialNumber to reflect */

	Rewind_InputFile();
	sprintf(Name, "SacMeans.s%d.%d.out",
				UnitNumber_Header(), RunNumber_Header());
	file = fopen(Name, (MACRO_APPENDS)?"a":"w");
	if (file==NULL) {
		fprintf(stderr, "Err opening %s", Name);
		Exit("", "Write_SacEndpts()");
		}

	Read_Next_Trial(SKIP_DATA);		/* Get 1st header	*/
	RunNumber = RunNumber_Header();		/* Same thru-out file?	*/
	Rewind_InputFile();			/* Back to start	*/

	while (Read_Next_Trial(WITH_DATA)) {
	   int trial = TrialNumber_Header();		/* Trial #	*/
	   float h,v;	
	   int TargStartH, TargStartV;

	   if (RunNumber != RunNumber_Header()) {	/* New run??	*/
	       RunNumber =  RunNumber_Header();		/* Remember it	*/
	       SequentialRun++;				/* And tally it	*/
	       }	/* Problem: trial # ambiguous if run # changes	*/

	   TargStartH = EventExtract(TARGET_ON, TWO, 1);
	   if (TargStartH == -9999)
	       TargStartH = TargStartV = 0;
	    else {
	       int TargetNumber = EventExtract(TARGET_PURSUIT, ONE, 1);
	           /* Often there's a pursuit that moves that start pos	*/ 
	       if (TargetNumber != FAIL) {
		  int Speed     = EventExtract(TARGET_PURSUIT, TWO, 1);
		  int StartTime = EventExtract(TARGET_PURSUIT, TIME, 1);
	          int StopOccur = 2;
		  int StopTime;

	          if (TargetNumber != 1)
	             Exit("1st pursue targ not targ #1\n", "Write_SacEndpts84");

		  while (EventExtract(TARGET_PURSUIT, TWO, StopOccur) != 0)
		     StopOccur++;  /* If there's a start there's a stop	*/
		  StopTime = EventExtract(TARGET_PURSUIT, TIME, StopOccur);
		  TargStartH += (Speed * (StopTime - StartTime)) / 100;
		  				/* Convert to deg * 10 */
		  }
	       TargStartV = EventExtract(TARGET_ON, THREE, 1);
	       }

	   Get_EyePosition(begin, end, &h, &v);

	   h -= TargStartH/10.;		/* Adjust for starting	*/
	   v -= TargStartV/10.;		/*  location		*/

	   fprintf(file, "%d %d %d %.2f %.2f ",
		 trial + SequentialRun * 10000,	/* Make trial# unambig	*/
	   	 StackNumber_Header(),
		 TableNumber_Header(),
		 h,v);

	   {
	   int event = TARGET_ON_POLAR;		/* Target event		*/
	   int occur = 1;			/* Which occurence #?	*/

	   if (EventExtract(TARGET_ON_POLAR,TWO,1) == FAIL) {
	      if (EventExtract(TARGET_RE_1,TWO,1) != FAIL)
	         event = TARGET_RE_1;
 	       else if (EventExtract(TARGET_ON,TWO,2) != FAIL) {
	         event = TARGET_ON;
		 occur = 2;
	       } else
	         fprintf(stderr, "Can't find target location!\n");
	      }
	   fprintf(file, "%.1f %.1f",
		 (EventExtract(event,TWO,occur)-TargStartH)/10.,
		 (EventExtract(event,THREE,occur)-TargStartV)/10.);
	   }

#ifdef NOT_USED_ANYMORE
/* REMOVED on 1-9-01 (LHS) -- not used for frame data; novelty data
  uses it, but those files now use macro 110,111 */
	   fprintf(file, " %d",	/* Fixation blank minus cue off	*/
		 EventExtract(TARGET_BLANK, TIME, 2) -	/* 1st tg blank	*/
		 EventExtract(TARGET_BLANK, TIME, 1));	/* 2nd blank	*/
#endif

	   fprintf(file, "\n");

/* Added new value on 2-11-00 LHS */
/* Divided by 10 on 4-20-00 LHS */
	   }
	
	fclose(file);
	}
/* ********************************************************************	*/

/* FUNCTION Write_SpikeCounts85 */
void Write_SpikeCounts85() {
	FILE *file;
	char Name[80];
	int  RunNumber;		/* Run number may change	*/
	int  SequentialRun = 0;	/* Count runs, chg TrialNumber to reflect */

	Rewind_InputFile();
	sprintf(Name, "SpikeCounts.s%d.%d.out", UnitNumber_Header(),
						RunNumber_Header());
	file = fopen(Name, (MACRO_APPENDS)?"a":"w");
	if (file==NULL) {
		fprintf(stderr, "Err opening %s", Name);
		Exit("", "Write_SpikeCounts()");
		}

	Read_Next_Trial(SKIP_DATA);		/* Get 1st header	*/
	RunNumber = RunNumber_Header();		/* Same thru-out file?	*/
	Rewind_InputFile();			/* Back to start	*/

	while (Read_Next_Trial(WITH_DATA)) {
	   int trial = TrialNumber_Header();		/* Trial #	*/
	   if (RunNumber != RunNumber_Header()) {	/* New run??	*/
	       RunNumber =  RunNumber_Header();		/* Remember it	*/
	       SequentialRun++;				/* And tally it	*/
	       }	/* Problem: trial # ambiguous if run # changes	*/

	   fprintf(file, "%d %d %d %d\n",
		trial + SequentialRun * 10000,	/* Make trial# unambig	*/
	   	StackNumber_Header(),
		TableNumber_Header(),
	   	Spikes_In_Interval(1));    
	}
	
	fclose(file);
	}
/* ********************************************************************	*/

#ifdef UNUSED
  static int GetBlankTime(int targnumber, int onoff, int occurrence);
#endif

/* FUNCTION Write_SacDuration86 */
void Write_SacDuration86() {
	FILE *file;
	char Name[80];
	int  RunNumber;		/* Run number may change	*/
	int  SequentialRun = 0;	/* Count runs, chg TrialNumber to reflect */
	extern float SacPeakVelocity_H, SacPeakVelocity_V;
	extern float SacPosition_H, SacPosition_V;

	Rewind_InputFile();
	sprintf(Name, "SacDurations.s%d.%d.out",
		UnitNumber_Header(), RunNumber_Header());
	file = fopen(Name, (MACRO_APPENDS)?"a":"w");
	if (file==NULL) {
	   fprintf(stderr, "Err opening %s", Name);
	   Exit("", "Write_SacDurations86()");
	   }

	Read_Next_Trial(SKIP_DATA);		/* Get 1st header	*/
	RunNumber = RunNumber_Header();		/* Same thru-out file?	*/
	Rewind_InputFile();			/* Back to start	*/

	while (Read_Next_Trial(WITH_DATA)) {
	   int trial = TrialNumber_Header();		/* Trial #	*/
	   int start = Get_Saccade_Time(1, 1, Interval_To_Stack_Time(-100), 0);
	   float Start_H = SacPosition_H;
	   float Start_V = SacPosition_V;
	   int end = Get_Saccade_Time(0, 1, Interval_To_Stack_Time(-100), 0);
	   float End_H = SacPosition_H;
	   float End_V = SacPosition_V;
	   int GoTime = TargetOffEventExtract(1, TIME, 1);
	   /* int peaktime =		* Sets 'PeakVelocity' variables */
		Get_Saccade_Peak_Velocity(1, Interval_To_Stack_Time(-200), 0);

			/* Possibly needed for some very old frame data?*/
	   if (GoTime < 0 || GoTime > start) {		/* Wrong!	*/
	      GoTime = EventExtract(TARGET_ON,TIME,3);	/* Eye-arm data?*/
	      }						/* (3rd targ on)*/

	   if (RunNumber != RunNumber_Header()) {	/* New run??	*/
	       RunNumber =  RunNumber_Header();		/* Remember it	*/
	       SequentialRun++;				/* And tally it	*/
	       }	/* Problem: trial # ambiguous if run # changes	*/

	   fprintf(file, "%d %d %d  %d  %.2f %.2f  %.2f %.2f %d\n",
		 trial + SequentialRun * 10000,	/* Make trial# unambig	*/
	   	 StackNumber_Header(),
		 TableNumber_Header(),
		 end-start,		/* Duration */
		 End_H-Start_H,		/* Amplitude */
		 End_V-Start_V,
		 SacPeakVelocity_H,	/* Velocity */
		 SacPeakVelocity_V,
		 start - GoTime);	/* Latency */
	   }
	
	fclose(file);
	}
/* ********************************************************************	*/

#ifdef UNUSED
static int GetBlankTime(targnumber, onoff, occurrence) {
	int count = (occurrence<LAST_OCCURRENCE) ? 0 : LAST_OCCURRENCE-1;
	int i = count;
	int temp;

	while ((temp=EventExtract(TARGET_BLANK, TWO, ++i)) != FAIL)
	  if (temp == onoff)				/* On or off?	*/
	    if (targnumber == -1 ||			/* Any targ?	*/
	           (EventExtract(TARGET_BLANK,ONE,i) == targnumber))
	      if (++count == occurrence)		/* Right #?	*/
	         break;
	if (temp == FAIL)
	   Exit("Requested BLANK not found", "align.c, GetBlankTime");

	return(EventExtract(TARGET_BLANK,TIME,i));
	}
#endif
/* ********************************************************************	*/
