/* FILE _macros/frame/vest_sensory.c */
/* ********************************************************************	*/

#include "../Deffs.h"


/* ********************************************************************	*/
/* Macro for displaying data from stacks 170-184, 270-284 */

/* Reshuffle stack and class so that:

   stack (70-74, 80-84):
      FROM POSITION ON THE LEFT:
	401:  world, upward   target	(70's, classes 1-4)
	402:  world, downward		(70's, classes 5-8)
	403:  eye,   upward		(80's, classes 1-4)
	404:  eye,   downward		(80's, classes 5-8)
      FROM POSITION ON THE RIGHT:
	411:  world, upward   target	(70's, classes 1-4)
	412:  world, downward		(70's, classes 5-8)
	413:  eye,   upward		(80's, classes 1-4)
	414:  eye,   downward		(80's, classes 5-8)

   stack (76-77, 86-87):
      FROM LEFT (-20):
        601:  world
	603:  eye
      FROM RIGHT (+20):
        611:  world
        613:  eye

   class:
   	3 to 7:
	   horiz component (3,4 = left, 5 = center, 6,7 = right)
 */

static void ChangeStackAndClass();
/* ********************************************************************	*/

/* FUNCTION VestSensory80 */
	 /* Rewrite file with stacks, classes changed */
void VestSensory80(char *file) {
	Rewind_InputFile();
	Open_OutputFile(file, ".sensory");
	while (Read_Next_Trial(SKIP_DATA)) {
	   ChangeStackAndClass();
	   Write_OutputFile();
	   }
	Close_OutputFile();
	}
/* ********************************************************************	*/

/* FUNCTION ChangeStackAndClass */
	 /* Change to more easily manipulated stack and class numbers	*/
static void ChangeStackAndClass() {
	int stack = StackNumber_Header() % 100;
	int class = TableNumber_Header();
	int onleft = (stack%2 == 0) ? 10 : 0;	/* Even stacks on left	*/


	if (stack < 70 || stack > 87)
	   return;


	/* UP & DOWN TARGETS */
	if (stack < 75) {			/* WORLD	*/
	   if (class >= 1 && class < 5) {	/* Targ up	*/
	      Set_StackNumber_Header(401+onleft);
              Set_StackName_Header(
	      	(onleft) ? "World:up (from L)" : "World:up (from R)");
	   } else {				/* Targ down	*/
	      Set_StackNumber_Header(402+onleft);
              Set_StackName_Header(
	      	(onleft) ? "World:dn (from L)" : "World:dn (from R)");
	      }
	   goto DO_VERTICAL_CLASSES;
	   }
	 
	 if (stack > 79 && stack < 85) {	/* EYE		*/
	   if (class >= 1 && class < 5) {	/* Targ up	*/
	      Set_StackNumber_Header(403+onleft);
              Set_StackName_Header(
	      	(onleft) ? "Eye: up (from L)" : "Eye: up (from R)");
	   } else {				/* Targ down	*/
	      Set_StackNumber_Header(404+onleft);
              Set_StackName_Header(
	      	(onleft) ? "Eye: dn (from L)" : "Eye: dn (from R)");
	      }
	   goto DO_VERTICAL_CLASSES;
	   }


	/* HORIZONTAL TARGETS */
	if (class > 4)
	    class -= 4;
        if (class == 4)
	    class = 5;
	if (stack % 2)
	    Set_ClassNumber_Header(7 - class);
         else
	    Set_ClassNumber_Header(class + 3);
	 switch (stack) {	/* No change in numbers, just names	*/
	  case 76: Set_StackName_Header("W from left"); break;
	  case 77: Set_StackName_Header("W from right"); break;
	  case 86: Set_StackName_Header("E from left"); break;
	  case 87: Set_StackName_Header("E from right"); break;
	  }
	return;

      DO_VERTICAL_CLASSES:
	if (class > 4 && class <= 8)
	   class -= 4;		/* Destroy up/down distinction	*/

	switch (class) {
	   case 1:
	      Set_ClassNumber_Header( (onleft) ? 4 : 6);
	      break;

	   case 2:
	      Set_ClassNumber_Header( (onleft) ? 5 : 5);
	      break;

	   case 3:
	      Set_ClassNumber_Header( (onleft) ? 6 : 4);
	      break;

	   case 4:
	      Set_ClassNumber_Header( (onleft) ? 7 : 3);
	      break;
	   }
	}
/* ********************************************************************	*/
/* ********************************************************************	*/
