/* FILE _macros/frame/vest_motor.c */
/* ********************************************************************	*/

#include "../Deffs.h"


/* ********************************************************************	*/
/* Macro for displaying data from stacks 170-187 or 270-287 */

/* Reshuffle stack and class so that:
   FOR 70-74, 80-84
   stack:
	300:  world	(70's)
	301:  eye,   	(80's)

      PLUS:
   		EYE POSITION
   	0:	Left    (started on right, went 20 deg left) (stack ~73)
	10: 	Middle	(started on right, went 10 deg left) (stack ~71)
	10:	Middle	(started on left,  went 10 deg right) (stack ~70)
	20:	Right   (started on left,  went 20 deg right) (stack ~72)

   class:
	3 to 7: vertical component upward,
		horiz saccade component (3,4=left, 5=center, 6,7=right)
	13 to 17: vertical component downward

   FOR 76-77, 86-87
   stack:
	500:  world	(70's)
	501:  eye,   	(80's)

      PLUS:
   		EYE POSITION
   	0:	Left    (started on right, went 10 deg left)
	10: 	Middle	(started on right, went  0 deg left)
	20:	Right   (started on left,  went 10 deg right)

   class:
	Same as 70-74, 80-84
 */

static void ChangeStackAndClass();
/* ********************************************************************	*/

/* FUNCTION VestMotor81 */
	 /* Rewrite file with stacks, classes changed */
void VestMotor81(char *file) {
	Rewind_InputFile();
	Open_OutputFile(file, ".motor");
	while (Read_Next_Trial(SKIP_DATA)) {
	   ChangeStackAndClass();
	   Write_OutputFile();
	   }
	Close_OutputFile();
	}
/* ********************************************************************	*/

/* FUNCTION ChangeStackAndClass */
	 /* Change to more easily manipulated stack and class numbers	*/
static void ChangeStackAndClass() {
	int stack = StackNumber_Header() % 100;
	int class = TableNumber_Header();
	int down = 0;

	if (stack < 70 && stack > 88)
	   return;

	if (stack % 10 > 4) {			/* DO HORIZIONTALS */
	   switch (stack) {
	     case 76:
	        if (class > 4) {
                   Set_StackName_Header("World from +10");
	           Set_StackNumber_Header(520);
		   if (class == 8)
		      Set_ClassNumber_Header(6);
		   else
	   	      Set_ClassNumber_Header(class-3);
	         } else {
                   Set_StackName_Header("World from 0");
	           Set_StackNumber_Header(510);
		   if (class == 4)
		      Set_ClassNumber_Header(7);
		   else
	   	      Set_ClassNumber_Header(class+2);
		   }
	        break;
	     case 77:
	        if (class > 4) {
                   Set_StackName_Header("World from -10");
	           Set_StackNumber_Header(500);
		   if (class == 8)
		      Set_ClassNumber_Header(4);
		   else
	   	      Set_ClassNumber_Header(13-class);
	         } else {
                   Set_StackName_Header("World from 0");
	           Set_StackNumber_Header(510);
		   if (class == 4)
		      Set_ClassNumber_Header(3);
		   else
	   	      Set_ClassNumber_Header(8-class);
		   }
	        break;
	     case 86:
	        if (class > 4) {
                   Set_StackName_Header("Eye from +10");
	           Set_StackNumber_Header(521);
	         } else {
                   Set_StackName_Header("Eye from 0");
	           Set_StackNumber_Header(511);
		   }
		if (class > 4)
		    class -= 4;
		if (class == 4)
		   Set_ClassNumber_Header(8);
		 else
	   	   Set_ClassNumber_Header(class+3);
	        break;
	     case 87:
	        if (class > 4) {
                   Set_StackName_Header("Eye from -10");
	           Set_StackNumber_Header(501);
	         } else {
                   Set_StackName_Header("Eye from 0");
	           Set_StackNumber_Header(511);
		   }
		if (class > 4)
		    class -= 4;
		if (class == 4)
		   Set_ClassNumber_Header(2);
		 else
	   	   Set_ClassNumber_Header(7-class);
	        break;
	     }
	     return;
	   }

					/* NOW DO VERTICAL & OBLIQUES */

	if (class > 4 && class <= 8) {		/* Downward?	*/
	   down = 1;				/* Set flag	*/
	   class -= 4;
	   }

	switch (stack) {
	   case 72:				/* 20 deg to right	*/
                Set_StackName_Header("World +10");
	        Set_StackNumber_Header(320);
	   	Set_ClassNumber_Header(5+class-4);
		break;
			
	   case 70:				/* 10 deg to right	*/
                Set_StackName_Header("World   0");
	        Set_StackNumber_Header(310);
	   	Set_ClassNumber_Header(5+class-3);
		break;
			
	   case 71:				/* 10 deg to left	*/
                Set_StackName_Header("World   0");
	        Set_StackNumber_Header(310);
	   	Set_ClassNumber_Header(5+3-class);
		break;
			
	   case 73:				/* 20 deg to left	*/
                Set_StackName_Header("World -10");
	        Set_StackNumber_Header(300);
	   	Set_ClassNumber_Header(5+4-class);
		break;

	   case 82:
                Set_StackName_Header("Eye +10");
	        Set_StackNumber_Header(321);
	   	Set_ClassNumber_Header(5+class-2);
		break;

	   case 80:
                Set_StackName_Header("Eye   0");
	        Set_StackNumber_Header(311);
	   	Set_ClassNumber_Header(5+class-2);
		break;

	   case 81:
                Set_StackName_Header("Eye   0");
	        Set_StackNumber_Header(311);
	   	Set_ClassNumber_Header(5+2-class);
		break;

	   case 83:
                Set_StackName_Header("Eye -10");
	        Set_StackNumber_Header(301);
	   	Set_ClassNumber_Header(5+2-class);
		break;
	   }

	if (down)
	   Set_ClassNumber_Header(10 + TableNumber_Header());
	}
/* ********************************************************************	*/
