/* FILE _macros/trialinfo.c */

#include "../Deffs.h"
#include "../../event.h"
#include <malloc.h>
/* ********************************************************************	*/
/* ********************************************************************	*/

/* FUNCTION Trial_Info801 */
	 /* Write individual trial data out for Splus import	*/
	 /* Append any arguments to 'title' to end of file	*/
void Trial_Info801() {
#ifdef DIAG
	int Types   = Count_TrialTypes();
	int MaxTrials = -1;
	int i;
	FILE *file;
   	char Name[80];

	Rewind_InputFile();		/* For consistent unit,run#	*/
   	sprintf(Name, "o%d.%d", UnitNumber_Header(), RunNumber_Header());
   	file = fopen(Name, (MACRO_APPENDS)?"a":"w");
   	if (file==NULL) {
      	   fprintf(stderr, "Err opening %s", Name);
      	   Exit("", "Write_OutputFiles0()");
      	   }

     	/* First line: unit.run begin(ms) end(ms) stacks classes trials	*/
	fprintf(file, "Unit.run  %d.%d\n",
   		UnitNumber_Header(), RunNumber_Header());
	fprintf(file, "\t%d stacks x %d classes\n",
		List_Length(STACK), List_Length(CLASS));
	fprintf(file, "\tInterval: %d to %d ms",
		Get_Interval_Begin(1), Get_Interval_End(1));
	if (Get_Interval_Type() == 2)
	   fprintf(file, " minus %d to %d ms",
		Get_Interval_Begin(2), Get_Interval_End(2));
	if (Get_Interval_Type() == 3)
	   fprintf(file, "   (2nd interval selected, not printed.)");
        fprintf(file, "\n\t%s\n", AlignTime_String());

	fprintf(file,
"Stack class\t mean\t SD \t SE \tN \t\t spikes per trial)\n");
		
	for (i=0; i<Types; i++)		/* Find max trials per class	*/
	    if (MaxTrials < Get_Interval_Count(i,1))
		MaxTrials = Get_Interval_Count(i,1);

	for (i=0; i<Types; i++) {
	    int count = Get_Interval_Count(i,1);
	    int *data = Get_Interval_Data(i,1);
	    int j;

	    fprintf(file, " %3d\t%2d\t%5.2f\t%4.2f\t%4.2f\t%2d \t\t",
		Get_TrialType_Info(i,STACK),
		Get_TrialType_Info(i,CLASS),

		Get_Interval_Mean(i,1),
		Get_Interval_SD(i,1),
		Get_Interval_SEM(i,1),
		count);

	    /* Now print spikes in interval for each trial	*/
	    for (j=0; j<count; j++)
	       fprintf(file, " %d", *(data+j));
	    /* while (++j<MaxTrials)
	       fprintf(file, " NA");
	     */
		 
	    fprintf(file, "\n");
	    }

		/* If there's a title, append it to output file	*/
	if (Get_Title_From_CmdLine())
	   fprintf(file, "%s\n", Get_Title_From_CmdLine());

	fclose(file);
	}
/* ********************************************************************	*/

void SpikePerMillisecondReport ( void )
{
  FILE *f ;
  int g ;
  int begin  = Get_Interval_Begin(1) + Get_ZeroTime();
  int end    = Get_Interval_End(1)   + Get_ZeroTime();
  int trials = 0 ;
  int interval_length = end - begin ;

  /* reserve memory for each ms of the interval */
  double *spike_buffer = (double*)malloc ( sizeof(double) * interval_length ) ;

  /* clear the buffer */
  for ( g = 0 ; g < interval_length ; g ++ ) spike_buffer[ g ] = 0.0 ;

  do
    {
      /* The following code is inspired by interval.c, Function: Spikes_In_Interval */

      int SpikeCount = SpikeCount_Header(-1);
      int i = 0;
      extern short Spikes[];
      short *spikes = Spikes;
      
      while ( i++ < SpikeCount )
	{
	  if ( *spikes >= begin && *spikes < end )
	    spike_buffer[ *spikes - begin ] += 1 ;

	  spikes++;				/* Get next spike	*/
	}
      trials++ ;
    }  
  while (Read_Next_Trial(WITH_DATA));

  /* open a file for writing results */

  f = fopen ( "spikecount" , (MACRO_APPENDS)?"a":"w" ) ;

  /* now write the spike buffer to a file */

  for ( g = 0 ; g < interval_length ; g ++ )
    fprintf ( f , "%.6f " , spike_buffer[ g ] / (double) trials) ;

  fprintf ( f , "\n" ) ;

  fclose ( f ) ;
#endif
}
