/* FILE _macros/frame/frame.c */
     /* Macro to determine frame of reference */
/* ********************************************************************	*/

#include "../Deffs.h"

/* ********************************************************************	*/

static void SwapTypes(int *one, int *two);
/* ********************************************************************	*/

/* FUNCTION Frame82 */
	 /*  */
void Frame82() {		/* 4:up/left 5:up 6:up/right; 15 dn,etc	*/ 
	int Update1, Update2; 			/* Updating		*/
	int Task1, Task2;			/* Task effect		*/

	int direction = Get_dataValue_From_CmdLine();


/* GET THE RELEVANT TYPES */
	{ 
	int class1 = 0, class2 = 0;
	int stack1;
					/* Trial types to test for:	*/
	if (List_Element(0,STACK) % 100 == 76) {
	   stack1 = List_Element(0,STACK);
	   class1 = class2 = 7;
	} else {
	 stack1 = 172;
	 if (List_Element(0,STACK) > 199)
	    stack1 += 100;

	 switch (direction % 10) {
	   case 6:				/* Up and right		*/
	   case 4:				/* Up and left		*/
	      class1 = class2 = 3;
	      break;

	   case 5:				/* Up			*/
	      class1 = 2;
	      class2 = 4;
	      break;
	   }

	 if (direction > 10) {
	   class1 += 4;
	   class2 += 4;
	   }
	 }

	Update1 = Get_StackClass_TrialType(stack1,   class1);
	Update2 = Get_StackClass_TrialType(stack1+1, class2);

	Task1 =   Get_StackClass_TrialType(stack1+10,   class1);
	Task2 =   Get_StackClass_TrialType(stack1+11, class2);

	if (direction==4 || direction==14) {	/* On left? Then swap	*/
	   SwapTypes(&Update1, &Update2);
	   SwapTypes(&Task1, &Task2);
	   }
	}		/* Now you have the relevant types		*/


	{		/* Now do tests & print results			*/
	FILE *file;
   	char Name[80];
	float value;

	Rewind_InputFile();		/* For consistent unit,run#	*/
   	sprintf(Name, "o%d.%d", UnitNumber_Header(), RunNumber_Header());
   	file = fopen(Name, (MACRO_APPENDS)?"a":"w");
   	if (file==NULL) {
      	   fprintf(stderr, "Err opening %s", Name);
      	   Exit("", "Write_OutputFiles0()");
      	   }

	fprintf(file, "Frame of reference analysis %d.%d,",
		UnitNumber_Header(), RunNumber_Header());
	fprintf(file,"  %d - %d ms", Get_Interval_Begin(1),Get_Interval_End(1));
	if (Get_Interval_Type() == 2)
	   fprintf(file," minus %d - %d ms",
	   	Get_Interval_Begin(2),Get_Interval_End(2));
	fprintf(file, "\n");

	value = Ttest_On_Interval(1, Update2, Update1, 2);
	if (value <= P_CRITERIA)
	   fprintf(file, " %s (P=%.3f) *", 
	    (Get_Interval_Mean(Update2, 1) > Get_Interval_Mean(Update1, 1)) ?
	       "Remapping" : "Anti-remap", value);
	else
	   fprintf(file, " Unclear (%s trend)",
	    (Get_Interval_Mean(Update2, 1) > Get_Interval_Mean(Update1, 1)) ?
	       "Remap" : "Anti-remap");

	fprintf(file, "  (Response: %.1f vs %.1f sp/s)\n",
		Get_Interval_Mean(Update2, 1),
		Get_Interval_Mean(Update1, 1));

	value = Ttest_On_Interval(1, Task2, Task1, 2);
	if (value <= P_CRITERIA)
	   fprintf(file, " %s (P=%.3f) *", 
	    (Get_Interval_Mean(Task2, 1) > Get_Interval_Mean(Task1, 1)) ?
	       "Sensory coding" : "Task dependence", value);
	else
	   fprintf(file, " Unclear (%s trend)",
	    (Get_Interval_Mean(Task2, 1) > Get_Interval_Mean(Task1, 1)) ?
	       "Sensory coding" : "Task dependence");

	fprintf(file, " (Response: %.1f vs %.1f)\n",
		Get_Interval_Mean(Task2, 1),
		Get_Interval_Mean(Task1, 1));

#ifdef MORE_DETAIL
	fprintf(file, "  Magnitude of differences: ");
	 {		 /* Are the differences equal?  Inverted?  Neither? */
	 float UpdateDiff = 
		Get_Interval_Mean(Update1, 1) - Get_Interval_Mean(Update2,1);
	 float TaskDiff = 
		Get_Interval_Mean(Task1, 1) - Get_Interval_Mean(Task2,1);
	 float UpdateSEM =  sqrt(
		Get_Interval_SEM(Update1,1) * Get_Interval_SEM(Update1,1) +
		Get_Interval_SEM(Update2,1) * Get_Interval_SEM(Update2,1));
	 float TaskSEM =  sqrt(
		Get_Interval_SEM(Task1,1) * Get_Interval_SEM(Task1,1) +
		Get_Interval_SEM(Task2,1) * Get_Interval_SEM(Task2,1));

	 int UpdateCount = Min(Get_Interval_Count(Update1,1),
	 		       Get_Interval_Count(Update2,1));
	 int TaskCount = Min(Get_Interval_Count(Task1,1),
	 		     Get_Interval_Count(Task2,1));

	 float Same = Ttest_short(TaskDiff, TaskCount, TaskSEM,
	 			  UpdateDiff, UpdateCount, UpdateSEM, 2); 
	 float Diff = Ttest_short(TaskDiff, TaskCount, TaskSEM,
	 			  -UpdateDiff, UpdateCount, UpdateSEM, 2); 
	 float GreaterThan = (TaskDiff > UpdateDiff);

	 int Code = (Same <= P_CRITERIA) +
	        2 * (Diff <= P_CRITERIA) +
		4 * (GreaterThan);

	 char *Responses[] = { "0", "1", "2", "3", "4", "5", "6", "7" };

	 fprintf(file, "    Differences are %s\n", Responses[Code]);
	 	
	 }
#endif
	fclose(file);
	}
	}
/* ********************************************************************	*/

static void SwapTypes(int *one, int *two) {
	int temp = *one;
	*one = *two;
	*two = temp;
	}
/* ********************************************************************	*/
