/* FILE _macros/field/frame.c */
   /* Plot responses assoc'd with cue or saccade as function of
   	e.g., saccade vector */

    /* Should be run with 	"grab -aa$ -i-200:0 -o71"		*/
/* ********************************************************************	*/

#include "../Deffs.h"
#include "../../event.h"

#include <stdlib.h>					/* exit(),abs()	*/
/* ********************************************************************	*/

#define USE_MOTOR_VECTOR	1	/* Pick just one of these	*/
#define USE_SENSORY_VECTOR	0
#define USE_INTENDED_VECTOR	0

#define H_BOUND			(100 * 30)	/* Plot size (100 * deg)*/
#define V_BOUND			(100 * 20)	/* Plot size (100 * deg)*/
#define SHOW_SINGLE_TRIALS	1
#define SCALE			7	/* Size of max rate		*/
#define GRANULARITY		3		/* In degrees		*/
#define MAX_CATEGORIES		(MAX_TYPES * 10)
#define TOP_SPACE		V_BOUND/2	/* Usu ~1500; for text	*/
/* ********************************************************************	*/

static int H_vector[MAX_CATEGORIES];
static int V_vector[MAX_CATEGORIES];
static int Rate[MAX_CATEGORIES];
static int Count[MAX_CATEGORIES];

static int CountOccurrenceOfEachType[MAX_TYPES];

static int Round(float number, int granularity);
/* ********************************************************************	*/
/* FUNCTION Frame71 */
	 /* Not a ascii output: a graphics output instead!		*/
	 /* Cartesian (for now) layout of spikes */
	 /* Note: scale factor of 100 everywhere; since all arguments
	    to ps.c are integers, would lose resolution otherwise	*/
void Frame71() {
	int i;
	int max_h_vector = 0;
	int max_v_vector = 0;
	int max_rate = 0;
	float scale;
	extern void Set_Dimensions_For_Coords(int row, int col);
        extern void Do_Header_Title(), Do_Class_Titles();
	extern void space(int a, int b, int c, int d);

#	if (USE_MOTOR_VECTOR+USE_SENSORY_VECTOR+USE_INTENDED_VECTOR != 1)
	illegal
#	endif

	for (i=0; i<MAX_CATEGORIES; i++)
	    Count[i] = Rate[i] = H_vector[i] = V_vector[i] = 0;

	for (i=0; i<MAX_TYPES; i++)
            CountOccurrenceOfEachType[i] = 0;

	/* Get firing rate, and vector from current eye to final eye */
	Rewind_InputFile();
	while (Read_Next_Trial(WITH_DATA)) {
	   int TimeAtFinalLocation = 0;
	   int TimeAtPreviousLocation = 0;
	   float Final_H, Final_V;
	   float Previous_H, Previous_V;
	   int h_vect, v_vect;

	   fprintf(stderr, "Update code!");
	   /* TimeAtFinalLocation = EventExtract(EYE_ACQUIRE,TIME,LAST_OCCURRENCE);
	    */
	   /* TimeAtPreviousLocation = EventExtract(EYE_SAC, TIME,LAST_OCCURRENCE);
	    */

	   /* Check for valid times */
	   if (TimeAtFinalLocation == FAIL) {
	      fprintf(stderr, "PANIC: Time at final location can't be found\n");
	      exit(0);
	      }
	   if (TimeAtPreviousLocation == FAIL) {
	      fprintf(stderr, "PANIC: Time at previous location not found\n");
	      exit(0);
	      }

	   /* Get eye position before and after saccade */
fprintf(stderr, "DIAG: Not sure if this is right!  You're giving a time\n\
 from stack extract, which is a raw stack time, which is different from\n\
 a time relative to the alignment point!  I'd have thought this would\n\
 not be correct!");
	   Get_EyePosition(
	        TimeAtFinalLocation + 100,
	   	TimeAtFinalLocation + 200,
		&Final_H, &Final_V);
	   Get_EyePosition(
	   	TimeAtPreviousLocation + 100,
	   	TimeAtPreviousLocation + 200,
		&Previous_H, &Previous_V);

	   if (USE_SENSORY_VECTOR) {
	      fprintf(stderr, "Update code!");
	      /* Previous_H = EventExtract(EYE_CUE, TWO,   1) / 10; */
	      /* Previous_V = EventExtract(EYE_CUE, THREE, 1) / 10; */
	      }

	   /* Calculate the vector lengths */
	   h_vect = Round(Final_H - Previous_H, GRANULARITY);
	   v_vect = Round(Final_V - Previous_V, GRANULARITY);
	   	   
	   /* Find entry with this vector, or make new entry */
	   for (i=0; i<MAX_CATEGORIES && Count[i]>0; i++)
	     if ((H_vector[i] == h_vect) &&
	         (V_vector[i] == v_vect))
	       break;
	   if (i<MAX_CATEGORIES) {
	      if (Count[i] == 0) {
	         H_vector[i] = h_vect;
	       	 V_vector[i] = v_vect;
		 Count[i] = 1;
	       } else
		 Count[i]++;
	    } else {
	      fprintf(stderr, "PANIC: Please increase MAX_CATEGORIES");
	      exit(0);
	      }

	   /* Find rate for this trial */
	   Rate[i] = *(Get_Interval_Data(
		 	Get_TrialType(), Get_Interval_Type())
		 	 + (CountOccurrenceOfEachType[Get_TrialType()]++));
	   }

	/* Get mean rate across trials for each vector location */
	 for (i=0; i<MAX_CATEGORIES && Count[i]>0; i++)
	    Rate[i] = (Rate[i] + Count[i]/2) / Count[i];


	/* Find limits to vector locations and max firing rate */
	for (i=0; i<MAX_CATEGORIES && Count[i]>0; i++) {
	   if (abs(H_vector[i]) > max_h_vector)
	      max_h_vector = abs(H_vector[i]);

	   if (abs(V_vector[i]) > max_v_vector)
	      max_v_vector = abs(V_vector[i]);

	   if (Rate[i] > max_rate)
	      max_rate = Rate[i];
	   }

	if (100*max_h_vector > H_BOUND)
	   fprintf(stderr, "Warning: H_BOUND too small!\n");
	if (100*max_v_vector > V_BOUND)
	   fprintf(stderr, "Warning: V_BOUND too small!\n");

	/* Setup space based on BOUNDS */
	space(-H_BOUND, -V_BOUND+TOP_SPACE/2, H_BOUND, V_BOUND+TOP_SPACE);
	/* Alternate method: */
	/* space(-130*max_h_vector, -130*max_v_vector,	*/
	/*        130*max_h_vector,  130*max_v_vector);	*/

	SetLineWidth(0);
        Color(0,8,8);

	/* Draw box around workspace (DIAGNOSTIC)	*/
	/* move(-110*max_h_vector, -110*max_v_vector); */
	/* cont( 110*max_h_vector, -110*max_v_vector); */
	/* cont( 110*max_h_vector,  110*max_v_vector); */
	/* cont(-110*max_h_vector,  110*max_v_vector); */
	/* cont(-110*max_h_vector, -110*max_v_vector); */

	move( 0, -100*max_v_vector);
	cont( 0,  100*max_v_vector);
	move(-100*max_h_vector,  0);
	cont( 100*max_h_vector,  0);

        Color(8,0,0);
	scale = SCALE * H_BOUND / max_rate;

	/* For each, plot circle proportional to firing rate */
	for (i=0; i<MAX_CATEGORIES && Count[i]>0; i++) {
	   if (Rate[i])
	      circle(100*H_vector[i], 100*V_vector[i], 2 * SCALE * Rate[i]);
	   else {
              Color(8,0,0);
	      circle(100*H_vector[i], 100*V_vector[i], SCALE);
              Color(0,0,0);
	      }
	   fill(1);
	   }

#ifdef DIAG
	filledbox(max_deg+max_rate/5, -max_deg-max_rate/3,
		  max_deg-max_rate/5, -max_deg+max_rate/3);

	fontsize(20);
	move(max_deg-SCALE*max_deg-20, max_deg);
	rotate(0, 0, 270);
	alabel('c', 'c', "Max rate");
	move(max_deg-SCALE*max_deg-20-20-13, max_deg);
	sprintf(tag, "(%d sp/s)", max_rate);
	alabel('c', 'c', tag);
	rotate(0, 0, 0);
	move(max_deg-SCALE*max_deg-20, -max_deg);
	rotate(0, 0, 270);
	alabel('c', 'c', "< 3 sp/s");

	fontsize(15);
	move(-max_deg-2*SCALE*max_deg, 0);
	sprintf(tag, "Furthest probe: %d deg", (max_deg+5)/10);
	alabel('c', 'c', tag);
	move(-max_deg-4*SCALE*max_deg, 0);
	alabel('c', 'c', "Grey scale shows significance");
	move(-max_deg-4*SCALE*max_deg, max_deg);
	alabel('c', 'c', "mean/SE = 3");
	move(-max_deg-4*SCALE*max_deg, -max_deg);
	alabel('c', 'c', "mean/SE = 1");
	rotate(0, 0, 0);

		/* Circle showing SE = mean */
	color((3*0xFFFF)/4, (3*0xFFFF)/4, (3*0xFFFF)/4);
	circle(-(int)(max_deg*1.3), -max_deg, SCALE*max_deg/2);
	fill(1);

		/* Circle showing SE = one-quarter mean */
	color(0xFFFF/4, 0xFFFF/4, 0xFFFF/4);
	circle(-(int)(max_deg*1.3), max_deg, SCALE*max_deg/2);
	fill(1);

#endif
	Set_Dimensions_For_Coords(1,2);
	Do_Header_Title();
	Do_Class_Titles(0);		/* No individuals	*/
	}	
/* ********************************************************************	*/

/* FUNCION Round */
static int Round(float number, int granularity) {
	int neg = number < 0.;
	int integer = (int) fabs(number);

	integer = ((integer + granularity/2)/ granularity) * granularity;
	if (neg)
	   integer = -integer;
	return(integer);
	}
/* ********************************************************************	*/
/* ********************************************************************	*/
