/* FILE _macros/field/flash.c */
    /* Plot receptive field based on flash responses */
    /* Uses stacks 11:18 */

    /* Should be run with 	"grab -at2 -i50:250 -xs10 -o70"		*/
    /*   Or, to substract bg:   "grab -at2 -i50:150 -B40 -xs10 -o70"		*/
/* ********************************************************************	*/

#include "../Deffs.h"
#include "../../event.h"
#include "../Function2.h"

#define LINEAR_VS_AREA	1	/* [1]Scale rate to radius(1) or area(0)*/
				/* Scaled by area doesn't quite work	*/
#define SCALE ((LINEAR_VS_AREA)? .07 : .6) /* [.07:.6] Size of max rate	*/
#define PRINTOUT	0	/* [0] vs screen: different line widths	*/

#define DRAW_MEAN	0	/* [0] Draw a line showing the mean	*/
#define DRAW_SEM	0	/* [0] Draw a line showing the SEM	*/
#define BAR_FOR_LOW	0	/* [0] Bars for spots w/out a response	*/
#define OUTLINE		0	/* [0] White borders - help see overlaps*/
#define COLOR_CODE	1	/* [1] Intensity code for significance	*/
#define SEM_SCALE	((LINEAR_VS_AREA) ? 10 : 15.) /*Intensity code	*/
					/* [10 : 15] */
#define DEBUG 		0
/* ********************************************************************	*/
#define SCALED(x)	\
	 (int) (((LINEAR_VS_AREA)? x : sqrt((double)x)) * scale)
/* ********************************************************************	*/

/* FUNCTION FlashFields70 */
	 /* Not a ascii output: a graphics output instead!		*/
	 /* Cartesian (for now) layout of spikes */
void FlashFields70() {
	int i;
	int max_deg = 0;		/* Farthest out target	*/
	int max_rate = 0;		/* Highest rate		*/
	int Types = Count_TrialTypes();
	float scale;
	char tag[80];
	int DrewCircle[40];
	int CircleCount = 1;
	extern int Get_Histo_Scale_From_CmdLine();

	for (i=0;i<40;i++)
	    DrewCircle[i] = -1;

	/* Find limits to cue locations and max firing rate */
	for (i=0; i<Types; i++) {
	   int order = Get_TrialType_Info(i, ORDER);
	   int h, v;

	   Rewind_InputFile();
	   while (--order >= 0)
	       Read_Next_Trial(SKIP_DATA);
	   h = AnyTargetEventExtract(TWO, 2) - AnyTargetEventExtract(TWO,1);
	   v = AnyTargetEventExtract(THREE, 2) - AnyTargetEventExtract(THREE,1);

	   if (h==FAIL)
	      Exit("Can't find target location", "macro 70, field/flash.c");

	   if ((int) sqrt(h * h + v * v) > max_deg)
	      max_deg = (int) sqrt(h * h + v * v);

	   if (Get_Interval_Mean(i, 1) > max_rate)
	      max_rate = Get_Interval_Mean(i, 1);
	   }

	i = Get_Histo_Scale_From_CmdLine();
	if (i > 0)
	   max_rate = i;
	else if (i < 0)
	   max_rate = max_rate * -i / 100;


	/* Setup space based on limits to cue locations */
	space((int)(-1.3*max_deg), (int)(-1.3*max_deg),
	      (int)( 1.3*max_deg), (int)( 1.3*max_deg));
        SetColor(0,0,0);
	SetLineWidth(0);

	scale = SCALE * max_deg / max_rate;
	circle(0,0, 50);
	circle(0,0, 100);
	if (max_deg >= 130)
	   circle(0,0, 140);
	if (max_deg >= 350)
	   circle(0,0, 200);
	if (max_deg >= 270)
	   circle(0,0, 280);
	if (max_deg >= 390)
	   circle(0,0, 400);
	Color(50,0,0);

	if (PRINTOUT)
	   SetLineWidth(1);
	/* For each stack, plot circle proportional to firing rate */
	for (i=0; i<Types; i++) {
	   int order = Get_TrialType_Info(i, ORDER);
	   int rate = Get_Interval_Mean(i, 1);
	   int h, v;	/* Don't read yet -- don't have right stack!	*/

#	   if COLOR_CODE
	   int ColoR = (int)(2 * 0xFFFF * rate / (float)Get_Interval_SEM(i,1)
	   							/ SEM_SCALE);
	   if (ColoR > 0xFFFF)
	       ColoR = 0xFFFF;

	   ColoR = 0xFFFF - ColoR;			/* Invert mapping */
#	   else
	   int ColoR = 0;
#	   endif

	   if (Read_Trial(order))
	      Exit("Err reading trial", "flash.c");

	   h = AnyTargetEventExtract(TWO, 2) - AnyTargetEventExtract(TWO,1);
	   v = AnyTargetEventExtract(THREE, 2) - AnyTargetEventExtract(THREE,1);

/* ********************************************************************	*/
/* DIAG: Unclear why, but h and v appear to be swapped and inverted. */
	   { int temp = h;
	   h = v;
	   v = -temp;
	   }
/* ********************************************************************	*/

#if DEBUG
fprintf(stderr, "DIAG: %d sp/s at %d x %d (stack %d.%d) (n=%d, mean/SEM=%.2f/%.2f = %.2f)\n",
  rate, h, v,
  Get_TrialType_Info(i, STACK), Get_TrialType_Info(i, CLASS),
  Get_TrialType_Info(i, NUMBER),
  Get_Interval_Mean(i,1), Get_Interval_SEM(i, 1),
  Get_Interval_Mean(i,1) / Get_Interval_SEM(i, 1));
#endif

	   if (rate >= 3 || (BAR_FOR_LOW==0)) {
	      SetColor(ColoR, ColoR, ColoR); 
	      circle(h,v, SCALED(rate));
	      /* if (rate > 20) fprintf(stderr, "DIAG: %d --> %d\n",
	          rate,
	          (int) (((LINEAR_VS_AREA)?rate:sqrt((float)rate)) * scale));
	       */
	      fill(1);

	      if (OUTLINE) {
	         Color(7,7,7);			/* Outline in white	*/
	         circle(h,v, SCALED(rate));
	         fill(0);
		 }

	      if (DRAW_SEM &&			/* Want an SEM bar?	   */
		  Get_Interval_SEM(i,1) < 0.5 * Get_Interval_Mean(i,1)) {
		/* Draw mean (horiz) and SEM (vert) lines in black */
	       if (Get_TrialType_Info(i, NUMBER) > 2) {
	         SetColor(0xFFFF,0xFFFF,0xFFFF);
	         move(h, v);
	         cont(h - (int)(Get_Interval_SEM(i,1)*scale), v);
		 }
	      }

	      if (DRAW_MEAN) {
	         SetColor(0xFFFF,0xFFFF,0xFFFF);
	         move(h, v + (int)(Get_Interval_Mean(i,1)*scale));
	         cont(h, v);
	         SetColor(0,0,0);
	         move(h, v);
	         cont(h, v - (int)(Get_Interval_Mean(i,1)*scale));
		 }
	    } else {
	      SetColor(0,0,0);
	      filledbox(h+max_rate/10, v+max_rate/6,
	                h-max_rate/10, v-max_rate/6);
	      }

	   /*SetColorByTrialType(i);*/
	   {	/* Draw big circles for each distance a target was at	*/
	   int j;
	   int size = (int) sqrt(h*h + v*v);

	   for (j=0; j<CircleCount; j++)
	      if (DrewCircle[j] == DrewCircle[CircleCount])
	         break;
	   if (j == CircleCount) {
	      DrewCircle[CircleCount++] = size;
	      circle(0,0, size);
	      }
           }
	   }				/* End of for loop for each type*/


	Color(8,0,0);
	circle(max_deg, max_deg, SCALED(max_rate));
	fill(1);

	/* SetColor(0,0,0); */
	if (BAR_FOR_LOW) {
	   filledbox(max_deg+max_rate/10, -max_deg-max_rate/6,
		     max_deg-max_rate/10, -max_deg+max_rate/6);
	   }

	fontsize(20);
	move(max_deg-SCALE*max_deg-20, max_deg);
	rotate(0, 0, 270);
	alabel('c', 'c', "Max rate");
	move(max_deg-SCALE*max_deg-20-20-13, max_deg);
	sprintf(tag, "(%d sp/s)", max_rate);
	alabel('c', 'c', tag);
	rotate(0, 0, 0);
	if (BAR_FOR_LOW) {
	   move(max_deg-SCALE*max_deg-20, -max_deg);
	   rotate(0, 0, 270);
	   alabel('c', 'c', "< 3 sp/s");
	   }
	rotate(0, 0, 270);

	fontsize(15);
	move(-max_deg-2*SCALE*max_deg, 0);
	sprintf(tag, "Furthest probe: %d deg", (max_deg+5)/10);
	alabel('c', 'c', tag);
	move(-max_deg-4*SCALE*max_deg, 0);
	alabel('c', 'c', "Grey scale proportional to t statistic");
	move(-max_deg-4*SCALE*max_deg, max_deg);
	alabel('c', 'c', "mean/SE = 4");
	move(-max_deg-4*SCALE*max_deg, -max_deg);
	alabel('c', 'c', "mean/SE = 2");
	rotate(0, 0, 0);

	if (COLOR_CODE) {		/* Circle showing SE = mean */
	   int ColoR = (int)(2 * 0xFFFF * 2./SEM_SCALE);/* SE = mean/2	  */
	   ColoR = 0xFFFF - ColoR;			/* Invert mapping */

	   SetColor(ColoR,ColoR,ColoR);
	   circle(-(int)(max_deg*1.3), -max_deg, SCALE*max_deg/2);
	   fill(1);
		/* Circle showing SE = one-sixth mean */
	   ColoR = (int)(2 * 0xFFFF * 4./SEM_SCALE);
	   ColoR = 0xFFFF - ColoR;			/* Invert mapping */
	   SetColor(ColoR,ColoR,ColoR);
	   circle(-(int)(max_deg*1.3), max_deg, SCALE*max_deg/2);
	   fill(1);
	   }

	Set_Dimensions_For_Coords(1,3);
	Do_Header_Title();
	Do_Class_Titles(0);		/* No individuals	*/
	}
/* ********************************************************************	*/
