/* FILE _macros/behavior/time.c */
     /* Ascii output of analysis program */
     /*  Print out reaction times, re: time 0 (set by -a on cmdline)	*/
     /*   Sort by stack and table */

#include "../Deffs.h"
#include "../../event.h"
/* ********************************************************************	*/

static FILE *file;

static void Get_Times();
/* ********************************************************************	*/
/* ********************************************************************	*/

/* FUNCTION Timing61 */
	 /* Reaction times for saccades */
	 /* APPEND to existing file:
	  *   stack class trial reaction-time
	  */	
void Timing61() {
  	char FileName[80];

        sprintf(FileName, "Times.%d.%d",
	        UnitNumber_Header(),
		RunNumber_Header());
        file = fopen(FileName, (MACRO_APPENDS)?"a":"w");

	if (file==NULL)
	   Exit("Err opening output file <Times>", "Open_OutputFiles()");
	Rewind_InputFile();
	while (Read_Next_Trial(WITH_DATA))
	    Get_Times();
	fclose(file);
	}
/* ********************************************************************	*/

/* FUNCTION Get_Times */
	 /* Print info about each trial */
static void Get_Times() {
	extern int Get_Saccade_Time();			/* sac.c	*/
	extern int Get_Saccade_Limited;

	int SacStart = AnyTargetEventExtract(TIME, LAST_OCCURRENCE);

	Get_Saccade_Limited = 0;	       /* Look till end of trial*/

	fprintf(file, 
	       "%d %d %d  %d\n",
		StackNumber_Header(),
		TableNumber_Header(),
		TrialNumber_Header(),
	        Get_Saccade_Time(1,1,SacStart+10,0)-SacStart);	/* Time */
	Get_Saccade_Limited = 1;			/* Reset	*/
	}
/* ********************************************************************	*/
