/* FILE success.c */
     /* Report  stack, class, RT (from macro 61) and delay time (macro 62) */

#include "../Deffs.h"
#include "../../event.h"
/* ********************************************************************	*/
static FILE *file;
static void Get_Data();
static void Get_Data52();
/* ********************************************************************	*/

/* FUNCTION Success 50 */
	 /* stack, class, RT, delay time from cue-target attn trials	*/
void Success50() {
	char FileName[80];
	extern int Get_Saccade_Limited;

	sprintf(FileName, "CueSuccess.%d.%d",
		UnitNumber_Header(),
		RunNumber_Header());
	file = fopen(FileName, (MACRO_APPENDS)?"a":"w");

	if (file==NULL)
	   Exit("Err opening output file <CueSuccess>", "Open_OutputFiles()");
	Rewind_InputFile();

#	if OLD_VERSION
	 fprintf(file, "Stack Class RT  Delay\n");
#	endif
	fprintf(file, "trial targ-x targ-y status RT target-shown dim\n");
	Get_Saccade_Limited = 0;	       /* Look till end of trial*/
	while (Read_Next_Trial(WITH_DATA))
	    Get_Data();
	fclose(file);
        Get_Saccade_Limited = 1;			/* Reset	*/
	}
/* ********************************************************************	*/

#if  OLD_VERSION
	/* We used this prior to Jan '07 */
/* FUNCTION Get_Data */
static void Get_Data() {

   extern int Get_Saccade_Time();			/* sac.c	*/

   int TargOn = AnyTargetEventExtract(TIME, LAST_OCCURRENCE);
   int Start = AnyTargetOffEventExtract(TIME, 1);	/* cue off	*/
   int ResponseTime = Get_Button_Time(0, -1, 1, TargOn+10, 0);

   if (Start > TargOn)
       Start = EventExtract(TAPE_ON, TIME, 1);

   if (ResponseTime == FAIL) {
      if (StackNumber_Header() >= 300)
	  ResponseTime = TargOn - 1;		/* RT will be "-1"	*/
      else
          ResponseTime = Get_Saccade_Time(1,1,TargOn+10,0);
      }

   fprintf(file, "  %2d   %2d %4d %4d\n",
   	StackNumber_Header(),
   	TableNumber_Header(),
        (TargOn == FAIL) ? -1 : ResponseTime - TargOn,
	(TargOn == FAIL) ? -1 : TargOn - Start);
/* LHS 12-12-06     (TargOn < Start) ? -1 : ResponseTime - TargOn, */
/* LHS 12-12-06	(TargOn < Start) ? -1 : TargOn - Start); 	   */
   }
#endif
/* ********************************************************************	*/
/* ********************************************************************	*/

/* FUNCTION Get_Data */
static void Get_Data() {

   int TargOn = AnyTargetEventExtract(TIME, 2);		/* 2nd target	*/
   int Start = EventExtract(TAPE_ON, TIME, 1);
   int ResponseTime = Get_Button_Time(0, -1, 1, TargOn, 0);
   extern int RunStatus_Header();

   if (TargOn!=FAIL && AnyTargetEventExtract(ONE, 2) != 3) /* targ 3?	*/
      Exit("Possible problem with targets!", "Get_Data");

   /* RunStatus_Header() - START_ERR, MONK_ERR, SUCCESS */
   /* ErrType_Header()   - eye or arm error		*/

   fprintf(file, "  %3d   %3d %2d %3d   %4d %4d %d\n",
	TrialNumber_Header(),
	EventExtract(TARGET_RE_1_POLAR,  TWO, 1)
	 - EventExtract(TARGET_ON, TWO, 1),	/* x coord	*/
	EventExtract(TARGET_RE_1_POLAR,THREE, 1)
	 - EventExtract(TARGET_ON, THREE, 1),	/* y coord	*/
	RunStatus_Header(),		/* ERROR or SUCCESS	*/
        (ResponseTime==FAIL || TargOn==FAIL) ? -1 : ResponseTime - TargOn,
	(TargOn == FAIL)       ? -1 : TargOn - Start,
	EventExtract(TARGET_RGB, THREE, 1) +
	EventExtract(TARGET_RGB, THREE, 2) +
	EventExtract(TARGET_RGB, THREE, 3)
	);
   }
/* ********************************************************************	*/
/* ********************************************************************	*/

/* FUNCTION Success 52 */
	 /* stack, class, RT, delay time from cue-target attn trials	*/
void Success52() {
	char FileName[80];
	extern int Get_Saccade_Limited;

	sprintf(FileName, "CueSuccess.%d.%d",
		UnitNumber_Header(),
		RunNumber_Header());
	file = fopen(FileName, (MACRO_APPENDS)?"a":"w");

	if (file==NULL)
	   Exit("Err opening output file <CueSuccess>", "Open_OutputFiles()");
	Rewind_InputFile();

	fprintf(file, 
"trial stack# distract:t/x/y targ:t/x/y newblk:t/x/y status RT(re:start) target-size\n");
	Get_Saccade_Limited = 0;	       /* Look till end of trial*/
	while (Read_Next_Trial(WITH_DATA))
	    Get_Data52();
	fclose(file);
        Get_Saccade_Limited = 1;			/* Reset	*/
	}
/* ********************************************************************	*/

/* FUNCTION Get_Data52 */
static void Get_Data52() {

   int Time2 = TargetEventExtract(2, TIME, 1);	/* targ 2 == distractor	*/
   int Time3 = TargetEventExtract(3, TIME, 1);	/* targ 3 == target	*/
   int Time4 = TargetEventExtract(4, TIME, 1);	/*targ 4==newblock-distr*/
   int ResponseTime = Get_Button_Time(0, -1, 1, 
		   (Time3==FAIL) ? Time2 : Time3, 0);
   int ButtonOnTime = Get_Button_Time(1, -1, 1, 
		   (Time3==FAIL) ? Time2 : Time3, 0);
   extern int RunStatus_Header();
   int size_occur;

   if (ButtonOnTime < ResponseTime)	/* Expect make before break	*/
       ResponseTime = ButtonOnTime;	/* But not always true		*/
   	/* Touches the response button before releasing the hold button	*/

   for (size_occur=1; size_occur<6; size_occur++)
       if (EventExtract(TARGET_SIZE, ONE, size_occur) == 3)
	   break;


   /* RunStatus_Header() - START_ERR, MONK_ERR, SUCCESS */
   /* ErrType_Header()   - eye or arm error		*/

   /* Times are all re: stack time 0, NOT tape-on time */
   fprintf(file, "  %4d %d  %3d %3d %3d   %3d %3d %3d   %3d %3d %3d   %4d   %4d   %d\n",
	TrialNumber_Header(),
	StackNumber_Header(),

	(Time2==FAIL) ? -1 : Time2,
	(Time2==FAIL) ? -1 : 
		TargetEventExtract(2, TWO, 1) - TargetEventExtract(1, TWO, 1),
	(Time2==FAIL) ? -1 : 
		TargetEventExtract(2, THREE, 1)-TargetEventExtract(1, THREE, 1),

	(Time3==FAIL) ? -1 : Time3,
	(Time3==FAIL) ? -1 : 
		TargetEventExtract(3, TWO, 1) - TargetEventExtract(1, TWO, 1),
	(Time3==FAIL) ? -1 : 
		TargetEventExtract(3, THREE, 1)-TargetEventExtract(1, THREE, 1),
	
	(Time4==FAIL) ? -1 : Time4,
	(Time4==FAIL) ? -1 : 
		TargetEventExtract(4, TWO, 1) - TargetEventExtract(1, TWO, 1),
	(Time4==FAIL) ? -1 : 
		TargetEventExtract(4, THREE, 1)-TargetEventExtract(1, THREE, 1),

	RunStatus_Header(),		/* ERROR or SUCCESS	*/
        (ResponseTime==FAIL) ? -9999 : ResponseTime,
		/* Not reporting distractor size - the same (we hope!)	*/
	EventExtract(TARGET_SIZE, TWO, size_occur)
	);
   }
/* ********************************************************************	*/
