/* FILE behavior/latency.c */
     /* Ascii output of analysis program */
     /*  Print out reaction times, re:LAST INFO RECEIVED  */  
     /*   Sort by stack and table */

#include "../Deffs.h"
#include "../../event.h"
/* ********************************************************************	*/
static FILE *file;
static void Extract_And_Store_Times();
/* ********************************************************************	*/

/* FUNCTION Latency 62*/
	 /* Reaction times for saccades and/or reaches */
void Latency62() {
	char FileName[80];

	sprintf(FileName, "L%d.%d",
				UnitNumber_Header(), RunNumber_Header());
	file = fopen(FileName, (MACRO_APPENDS)?"a":"w");
	fprintf(file,"Type\tDelay\tEye\tArm\tArm2\n");
	if (file==NULL)
	   Exit("Err opening output file <Latency>", "Open_OutputFiles()");
	Rewind_InputFile();
	while (Read_Next_Trial(WITH_DATA))
	    Extract_And_Store_Times();

	fclose(file);
	}

/* ********************************************************************	*/
/* FUNCTION Extract_And_Store_Times */
	 /* Begin looking MARGIN ms late (miss anticipatory responses)	*/
static void Extract_And_Store_Times() {
	extern int Get_Arm_Time();			/* switch.c	*/
	extern int Get_Saccade_Time();			/* sac.c	*/

	/* An eye (1), arm (0)or eye+arm (2) trial? (& see below)	*/
	int type = EventExtract(ACQUIRE,ONE,LAST_OCCURRENCE);	/* 0|1	*/
	/* Is this a Cue-Target or a Target-Cue trial?		*/
	int CueTarget = (AnyTargetEventExtract(TWO, 2) == 0) &&
	                (AnyTargetEventExtract(THREE, 2) == 0);
	/* Time of last piece of information */
	int LastStimulus = AnyTargetEventExtract(TIME, 3);

	int EyeLatency;
	int ArmLatency;
	int ArmMovement;

	int DelayTime = AnyTargetEventExtract(TIME, 3) - 
			AnyTargetEventExtract(TIME, 2);

	if (LastStimulus == FAIL) {	/* Spatial memory trial!	*/
		/* Sometimes fix pt blanks; other times it shrinks	*/
	   LastStimulus = 		/* Either a blank OR a shrink	*/
	      (EventExtract(TARGET_BLANK, TWO, 2) == ON) ?
		  EventExtract(TARGET_BLANK, TIME, 2)    :
		  EventExtract(TARGET_REDRAW,TIME, LAST_OCCURRENCE);

		/* ivf, 234 stacks: neither blank nor shrink - turn off!*/
	   if (LastStimulus < EventExtract(TARGET_BLANK,TIME,1))
	       LastStimulus = EventExtract(TARGET_OFF, TIME, 1);
		/* Redraw (fix off) must FOLLOW perif targ blank; if it	*/
		/* doesn't, use the 1st target off instead of redraw	*/

	   DelayTime = LastStimulus - EventExtract(TARGET_BLANK, TIME, 1);
	   if (LastStimulus == FAIL)	/* Special case (not eye-arm data)*/
	       DelayTime = AnyTargetEventExtract(TIME, 2) - 
			   AnyTargetEventExtract(TIME, 1);
	   if (EventExtract(ACQUIRE,ONE,LAST_OCCURRENCE) -
	       EventExtract(ACQUIRE,ONE,LAST_OCCURRENCE-1) < 50)
	      type = 2;			/* Must be an eye + arm type	*/
	   goto SKIP_TESTS;
	   }

	if (CueTarget==0)
	   DelayTime = -DelayTime;

	/* Be sure you have the right targets for calculating delay time*/
	if (AnyTargetEventExtract(TIME, 3) <
	    EventExtract(DELAY,TIME,LAST_OCCURRENCE))
	  Exit("Third target comes before delay!", "ExtractAndStoreTimes");
	if (AnyTargetEventExtract(TIME, 2) >
	    EventExtract(DELAY,TIME,LAST_OCCURRENCE))
	  Exit("Second target comes after delay!", "ExtractAndStoreTimes");

	if (EventExtract(ACQUIRE,TIME,LAST_OCCURRENCE+1) >
	    EventExtract(DELAY,TIME,LAST_OCCURRENCE))
	  type = 2;			/* Must be an eye + arm type	*/

SKIP_TESTS:
	if (type == 1)			/* If an eye type		*/
	   ArmLatency = ArmMovement = FAIL;
	else {
	   ArmLatency =
	   	Get_Arm_Time(OFF,FORWARD,LastStimulus,0) - LastStimulus;	
	   ArmMovement =
	   	Get_Arm_Move_Time(LastStimulus,0) - LastStimulus;
	   }
	if (type == 0)			/* If an arm type		*/
	   EyeLatency = FAIL;
	else {
	   EyeLatency =
		Get_Saccade_Time(1,FORWARD,LastStimulus+MARGIN,0) - LastStimulus;
	   }

	if (DelayTime == -FAIL)
	    DelayTime = FAIL;
	if (EyeLatency == FAIL - LastStimulus)
	    EyeLatency = FAIL;
	if (ArmLatency == FAIL - LastStimulus)
	    ArmLatency = FAIL;
	if (ArmMovement == FAIL - LastStimulus)
	    ArmMovement = FAIL;

	if (PRINT_TIMES || DEBUG)
	  fprintf(stderr,
	       "%d (%d): Last info %d  Eye: %d  Arm lift: %d  Arm move: %d\n",
	     TrialNumber_Input(),
	     TrialNumber_Header(),
	     LastStimulus-Get_TapeOnTime(),
	     LastStimulus-Get_TapeOnTime()+EyeLatency,
	     (ArmLatency==FAIL)? FAIL:
				LastStimulus-Get_TapeOnTime()+ArmLatency,
	     LastStimulus-Get_TapeOnTime()+ArmMovement);
	if (DEBUG)
	   fprintf(stderr, "  (last=%d, tape=%d, eye=%d, arm=%d,%d)\n",
	     LastStimulus,Get_TapeOnTime(),EyeLatency,ArmLatency,ArmMovement);

	fprintf(file, "%d %d %d %d %d\n",
		type, DelayTime, EyeLatency, ArmLatency, ArmMovement);
	}
/* ********************************************************************	*/

/* FUNCTION Timing61 */
	 /* Reaction times for saccades */
	 /* APPEND to existing file:
	  *   stack class trial reaction-time
	  */	
void Timing61() {
  	char FileName[80];

        sprintf(FileName, "Times.%d.%d",
	        UnitNumber_Header(),
		RunNumber_Header());
        file = fopen(FileName, (MACRO_APPENDS)?"a":"w");

	if (file==NULL)
	   Exit("Err opening output file <Times>", "Open_OutputFiles()");
	Rewind_InputFile();
	while (Read_Next_Trial(WITH_DATA))
	    Get_Times();
	fclose(file);
	}
/* ********************************************************************	*/

/* FUNCTION Get_Times */
	 /* Print info about each trial */
static void Get_Times() {
	extern int Get_Saccade_Time();			/* sac.c	*/
	extern int Get_Saccade_Limited;

	int SacStart = AnyTargetEventExtract(TIME, LAST_OCCURRENCE);

	Get_Saccade_Limited = 0;	       /* Look till end of trial*/

	fprintf(file, 
	       "%d %d %d  %d\n",
		StackNumber_Header(),
		TableNumber_Header(),
		TrialNumber_Header(),
	        Get_Saccade_Time(1,1,SacStart+10,0)-SacStart);	/* Time */
	Get_Saccade_Limited = 1;			/* Reset	*/
	}
/* ********************************************************************	*/
