/* FILE error.c */
     /* Return time of error, time of targ onset (or FAIL), stack, class */

#include "../Deffs.h"
#include "../../event.h"
/* ********************************************************************	*/
static FILE *file;
static void Get_Data();
/* ********************************************************************	*/

/* FUNCTION Failure 51 */
	 /* stack,class,delay+err times,err type (<0 wrong targ),RT	*/
	 /* Err types: 0:no sac 1:out to targ & back  2: close to targ	*
	  * 	-1: to wrong target      -2: false alarm		*
	  *  RT: if went to correct type (err type > 0), what's sac RT?	*/
void Failure51() {
	char FileName[80];
	extern int Get_Saccade_Limited;
	extern int Get_Saccade_Quietly;

	sprintf(FileName, "CueFailure.%d.%d",
		UnitNumber_Header(),
		RunNumber_Header());
	file = fopen(FileName, (MACRO_APPENDS)?"a":"w");

	if (file==NULL)
	   Exit("Err opening output file <CueFailure>", "Open_OutputFiles()");
	Rewind_InputFile();

	fprintf(file,"Trial Stack Class Delay ErrMs Type  RT  FixDist TargDist TargDist2\n");
	Get_Saccade_Limited = 0;	       /* Look till end of trial*/
	Get_Saccade_Quietly = 1;	       /* No msg; return FAIL	*/
	while (Read_Next_Trial(WITH_DATA))
	    Get_Data();
	fclose(file);
        Get_Saccade_Limited = 1;			/* Reset	*/
	Get_Saccade_Quietly = 0;	       		/* Reset	*/
	}
/* ********************************************************************	*/

/* FUNCTION Get_Data */
static void Get_Data() {

   extern int Get_Saccade_Time();			/* sac.c	*/

   int TargOn = AnyTargetEventExtract(TIME, LAST_OCCURRENCE);
   int CueOff = AnyTargetOffEventExtract(TIME, 1);
   int ErrTime = EventExtract(ERROR_STACK_BEGIN, TIME, 1);
   int LastSuccessfulAcquire = EventExtract(ACQUIRE, TIME, LAST_OCCURRENCE);
   int ErrType =  FAIL;
   int SacTime = FAIL;

   float H = AnyTargetEventExtract(TWO, LAST_OCCURRENCE) / 10;
   float V = AnyTargetEventExtract(THREE, LAST_OCCURRENCE) / 10;
   float H_fix = AnyTargetEventExtract(TWO, 1) / 10;	/* Fixation pt	*/
   float V_fix = AnyTargetEventExtract(THREE, 1) / 10;

   float h, v;						/* Eye pos	*/

   float FixDistance,
	 TargDistance,
	 TargDistance2 = -1;  /* 2: after 1st sac	*/
   	/* Final(ErrTime) eye pos from fix pt & from target; eye pos from
	 * target after the first saccade				*/

   if (ErrTime < CueOff + 150)			/* Err before cue - skip*/
      return;

   Get_EyePosition(ErrTime-Get_AlignTime()-100,		/* 100 ms before*/
		   ErrTime-Get_AlignTime(),		/* Err time	*/
		   &h, &v);				/* Put pos here	*/

   FixDistance = sqrt(pow(h-H_fix,2) + pow(v-V_fix,2));
   TargDistance = sqrt(pow(h-H,2)    + pow(v-V,2));

   if (TargOn < CueOff) { /* No target (last TARGET_ON is cue on)	*/
       ErrType = -2;	  /* None presented, or moved before it appeared*/
       goto DONE;					/* False alarm	*/
       }

   if (LastSuccessfulAcquire < TargOn) { /* Targ on, but stayed at fixpt*/
       ErrType = 0;		/* 1st post-targ acquire is "move eye"	*/
       goto DONE;		/* So targ on but no movement		*/
       }

   /* Left fixation point after or just before the target appeared	*/
   SacTime = Get_Button_Time(0,-1,1,TargOn-500,0);	/* First release*/
   if (SacTime == FAIL)
      SacTime = Get_Saccade_Time(1,1,TargOn-500,0);	/* (stack time)	*/

   if (SacTime == FAIL) {/* Reach says we left fix; grab can't find sac	*/
      Warning("Can't find sac/reach (but reach says it should be there)\n");
      SacTime = ErrTime - 80;			/* Fake the sac time	*/
      /* Alternative: ErrType = 0; goto DONE;	*/
      }
   if (SacTime < TargOn + 150) {		/* Nostart error - skip	*/
      ErrType = -2;		/* Moved too soon - jumped the gun	*/
      }

   Get_EyePosition(SacTime-Get_AlignTime()+60,		/* End of sac	*/
		   SacTime-Get_AlignTime()+100,		/* a bit later	*/
		   &h, &v);				/* Put pos here	*/

   TargDistance2 = sqrt(pow(h-H,2)    + pow(v-V,2));

   if (ErrType == -2)
      goto DONE;	/* Moved too soon - don't check if went to targ	*/

   if (Get_Button_Time(0,-1,1,TargOn-500,0) != FAIL) {
      ErrType = -1;				/* Went to 'wrong' target*/
      goto DONE;	/* OR: didn't hit target button	(DIAG) */
      }
     
   if (TargDistance < 7.) {	/* Moved close to target,not close enuf	*/
      ErrType = 2;				/* (Outside the window)	*/
      goto DONE;
      }

   if (TargDistance2 < 4.) {	/* Moved to target, but left too soon	*/
      ErrType = 1;
      goto DONE;
      }

   ErrType = -1;				/* Went to wrong target	*/

   DONE:
   fprintf(file, "%4d   %2d    %2d  %5d  %5d %2d  %4d %6.1f %8.1f %10.1f\n",
	TrialNumber_Header(),
   	StackNumber_Header(),
   	TableNumber_Header(),
	(TargOn-CueOff > 0) ? TargOn - CueOff : ErrTime - CueOff,
	ErrTime - CueOff,
	ErrType,
	(SacTime == FAIL) ? -1 : SacTime - TargOn,
	FixDistance,
	TargDistance,
	TargDistance2);
   }
/* ********************************************************************	*/
