/* FILE _macros/coord/reference.c */

#include "../Deffs.h"

#include "../../event.h"
/* ********************************************************************	*/
/* ********************************************************************	*/

/* FUNCTION Reference20() */
void Reference20() {
	FILE *file;
   	char Name[80];
	int s,c;
	int Stacks = List_Length(STACK);
	int Classes = List_Length(CLASS);
	int TestEndOfFile;

	Rewind_InputFile();		/* For consistent unit,run#	*/
   	sprintf(Name, "Reference.out");
   	file = fopen(Name, (MACRO_APPENDS)?"a":"w");
   	if (file==NULL) {
      	   fprintf(stderr, "Err opening %s", Name);
      	   Exit("", "Write_OutputFiles0()");
      	   }

	for (s=0; s<Stacks; s++)
	 for (c=0; c<Classes; c++) {
	   int stack = List_Element(s, STACK);
	   int class = List_Element(c, CLASS);
	   int type = Get_StackClass_TrialType(stack, class);

	   if (type == FAIL)
	      continue;

	   fprintf(file, "%d %d %d %.2f %.2f %d",
		  UnitNumber_Header(),
		  stack, class,
		  Get_Interval_Mean(type,1),
		  Get_Interval_SEM(type, 1),
		  Get_Interval_Count(type, 1)
		);

	   Rewind_InputFile();		/* Be sure you don't miss one	*/
	   while ((TestEndOfFile = Read_Next_Trial(SKIP_DATA)))  /* =, not == */
	      if (StackNumber_Header()==stack && TableNumber_Header()==class)
		 break;

	   if (TestEndOfFile == 0)
	      fprintf(stderr, "Cannot find stack %d, class %d\n", stack, class);

	   if (EventExtract(TARGET_ON_POLAR, ONE, 1) != 0 ||
	       EventExtract(TARGET_ON_POLAR, ONE, 2) != 1 ||
	       EventExtract(TARGET_ON_POLAR, ONE, 3) != 3)
	      fprintf(stderr, "Target onsets out of order!\n");

	   fprintf(file, "  %d %d   %d %d   %d %d\n",
	       EventExtract(TARGET_ON_POLAR, TWO, 1),
	       EventExtract(TARGET_ON_POLAR, THREE, 1),
	       EventExtract(TARGET_ON_POLAR, TWO, 2),
	       EventExtract(TARGET_ON_POLAR, THREE, 2),
	       EventExtract(TARGET_ON_POLAR, TWO, 3),
	       EventExtract(TARGET_ON_POLAR, THREE, 3));
	   }

	fclose(file);
	}
/* ********************************************************************	*/
/* ********************************************************************	*/
