/* FILE _macros/sac_endpt.c */
     /* Specifically for stacks 25-27, effects of sacs to flashed targs	*/
/* ********************************************************************	*/

#include "../Deffs.h"

#define BOUND			8	/* Size of plot (degrees)	*/
#define SHOW_SINGLE_TRIALS	1
/* ********************************************************************	*/
/* Test for effects of saccades to flashing stimuli, with either
   in- or out-phase modulation */

/* Stack 25 is single targets, 26 is in phase, 27 is out of phase */
/* Lowest stack is single targ, next is in phase, next is out	*/
/* ********************************************************************	*/

static void Init_Stuff();
static void Tally_Trials();
static void Do_Picture();
/* ********************************************************************	*/
/* ********************************************************************	*/

/* FUNCTION SacEndPoints60 */
	 /* Not a ascii output: a graphics output instead!		*/
void SacEndPoints60() {
	Rewind_InputFile();
	Init_Stuff();
	while (Read_Next_Trial(WITH_DATA))
	   Tally_Trials();
	Do_Picture();
	}
/* ********************************************************************	*/
/* ********************************************************************	*/
/* ********************************************************************	*/

#define MAX_STACKS	 3
#define MAX_CLASSES	24

static float H_sum[MAX_STACKS][MAX_CLASSES];
static float V_sum[MAX_STACKS][MAX_CLASSES];
static float H_sum2[MAX_STACKS][MAX_CLASSES];
static float V_sum2[MAX_STACKS][MAX_CLASSES];
static int n[MAX_STACKS][MAX_CLASSES];
/* ********************************************************************	*/

/* FUNCTION Init_Stuff */
static void Init_Stuff() {
	int i,j;
	extern void space(int a, int b, int c, int d);

	for (i=0; i<MAX_STACKS; i++)
	   for (j=0; j<MAX_CLASSES; j++) {
	      n[i][j] = 0;
	      H_sum[i][j] = V_sum[i][j] =
	      H_sum2[i][j] = V_sum2[i][j] = 0.;
	      }

	space((int)(-100*BOUND*0.7), -100*BOUND, (int)(100*BOUND*1.3), 100*BOUND);

        SetColor(0,0,0);
	SetLineWidth(0);
	move(-1500,0);					/* Cross-hairs	*/
	cont( 1500,0);

	move(0,-1500);
	cont(0, 1500);

	}
/* ********************************************************************	*/

/* FUNCTION Tally_Trials */
static void Tally_Trials() {
	int fig = Get_TrialType();	/* Fig type: indexes info	*/
	int stack = Get_TrialType_Info(fig, STACK);
	int class = Get_TrialType_Info(fig, CLASS);
	float h,v;

	stack = List_Index(stack, STACK) - 1;		/* Map from 0:2	*/
	n[stack][class]++;				/* Tally it	*/

fprintf(stderr, "DIAG: Not at all convinced that this works!");
	Get_EyePosition(Get_Interval_Begin(1), Get_Interval_End(1) , &h, &v);

	H_sum [stack][class] += h;
	H_sum2[stack][class] += h * h;

	V_sum [stack][class] += v;
	V_sum2[stack][class] += v * v;

	if (SHOW_SINGLE_TRIALS) {
	   switch (stack) {
	     case 0: SetColor(0,0,0);         break;	/* Black 	*/
	     case 1: SetColor(0,0xFFFF,0);    break;	/* Green 	*/
	     case 2: SetColor(0xFFFF,0,0);    break;	/* Red 		*/
	     }
	   point((int)(100*h),(int)(100*v));
	   }
	}
/* ********************************************************************	*/

/* FUNCTION Do_Picture */
static void Do_Picture() {
	int i, j;
	int H_Mean_GrandSum[3] = { 0, 0, 0 };
	int V_Mean_GrandSum[3] = { 0, 0, 0 };
	int H_SD_GrandSum[3]   = { 0, 0, 0 };
	int V_SD_GrandSum[3]   = { 0, 0, 0 };
	int N_GrandSum[3] = {0,0,0};

	for (i=0; i<3; i++) {
	   switch (i) {
	     case 0: SetColor(0,0,0);         break;	/* Black 	*/
	     case 1: SetColor(0,0xFFFF,0);    break;	/* Green 	*/
	     case 2: SetColor(0xFFFF,0,0);    break;	/* Red 		*/
	     }
	   for (j=0; j<MAX_CLASSES; j++)
	      if (n[i][j] > 2) {
	         float H_Sum = H_sum[i][j];
	         float V_Sum = V_sum[i][j];
	         int N = n[i][j];
	         int H_Mean = (int) (100*H_Sum / N);
	         int V_Mean = (int) (100*V_Sum / N);
	         int H_SD = (int) (100*SD(H_Sum, H_sum2[i][j], N));
	         int V_SD = (int) (100*SD(V_Sum, V_sum2[i][j], N));
	         int H_SE = (int) (100*SE(H_Sum, H_sum2[i][j], N));
	         int V_SE = (int) (100*SE(V_Sum, V_sum2[i][j], N));

		 H_Mean_GrandSum[i] += H_Mean;
		 V_Mean_GrandSum[i] += V_Mean;

		 H_SD_GrandSum[i] += H_SD;
		 V_SD_GrandSum[i] += V_SD;

		 N_GrandSum[i]++;
		 

		 if (i==1)
		    fprintf(stderr, "class %d: n = %d vs %d\n", j, N, n[2][j]);

		 /* 
	         SetLineWidth(1);
	         box(H_Mean + H_SD, V_Mean + V_SD,
	      	     H_Mean - H_SD, V_Mean - V_SD);
                  */
	         SetLineWidth(2);
	         /* filledbox( */
		 box(
		     H_Mean + H_SE, V_Mean + V_SE,
	      	     H_Mean - H_SE, V_Mean - V_SE);
	         }
	    }

	{ int m, s, M, S;	/* Low case: horiz     Up case: vert	*/
	m = (int) H_Mean_GrandSum[1]/(float)N_GrandSum[1] -
	          H_Mean_GrandSum[0]/(float)N_GrandSum[0];
	M = (int) V_Mean_GrandSum[1]/(float)N_GrandSum[1] -
	          V_Mean_GrandSum[0]/(float)N_GrandSum[0];
	s =       H_SD_GrandSum[1]/N_GrandSum[1];
	S =       V_SD_GrandSum[1]/N_GrandSum[1];
	SetColor(0,0xFFFF,0);
	box(m+s, M+S, m-s, M-S);

	m = (int) H_Mean_GrandSum[2]/(float)N_GrandSum[2] -
	          H_Mean_GrandSum[0]/(float)N_GrandSum[0];
	M = (int) V_Mean_GrandSum[2]/(float)N_GrandSum[2] -
	          V_Mean_GrandSum[0]/(float)N_GrandSum[0];
	s =       H_SD_GrandSum[2]/N_GrandSum[2];
	S =       V_SD_GrandSum[2]/N_GrandSum[2];
	SetColor(0xFFFF,0,0);
	box(m+s, M+S, m-s, M-S);

	s =       H_SD_GrandSum[0]/N_GrandSum[0];
	S =       V_SD_GrandSum[0]/N_GrandSum[0];
	SetColor(0,0,0);
	box(0+s, 0+S, 0-s, 0-S);
	}
	}	
/* ********************************************************************	*/
