/* FILE movememnt_times.c */
     /* Macros 63 (modelled on 86), 64, 65 */
/* ********************************************************************	*/

#include "../Deffs.h"

#include "../../event.h"
/* ********************************************************************	*/

/* FUNCTION Movement_times63() */
/* FUNCTION macro 64() -- also calls 63! */
	 /* Eye and limb data! */
	/* MUST BE ALIGNED ON THE 'GO' SIGNAL !! */
	/* Set "-D1" on saccade trials to skip Get_Arm_Stop_Time() errs	*/
	/*  or "-oa0" to skip arm code, output FAILS (better than -D1) 	*/
	/* Set "-oa1" to add arm positions				*/
	/* Set "-d1" to force it to NOT use buttons for arm latency	*/
	/* Set "-ot" to start looking for a saccade at some time re:'go'*/
	/*  Default is -50 ms, but you might want to go longer!		*/
void Movement_times63(int FindSecondLimb) {
	FILE *file;
	int  RunNumber;		/* Run number may change	*/
	int  SequentialRun = 0;	/* Count runs, chg TrialNumber to reflect */
	extern float SacPeakVelocity_H, SacPeakVelocity_V;
	extern float SacPosition_H, SacPosition_V;

	extern int Get_Saccade_Limited;
	extern int Get_Saccade_Stringent;

	Get_Saccade_Limited = 0;		/* Don't stop looking!	*/
	Get_Saccade_Stringent = 0;		/* Just find large ones	*/

	Rewind_InputFile();

	file = Open_Macro_Output("Movements", -1);	/* AFTER rewind	*/

	Read_Next_Trial(SKIP_DATA);		/* Get 1st header	*/
	RunNumber = RunNumber_Header();		/* Same thru-out file?	*/
	Rewind_InputFile();			/* Back to start	*/

	while (Read_Next_Trial(WITH_DATA)) {
	   int trial = TrialNumber_Input();		/* Trial #	*/
	   int GoTime = Interval_To_Stack_Time(0);	/* 'Go' signal	*/


           { int vsync = EventExtract(V_SYNC, TIME, 2);    /* Sync off	*/
	     if (vsync != FAIL) {
		if (vsync - GoTime > 40 || vsync < GoTime)
                    Warning("Odd V_SYNC event (behavior/movement.c)");
		else if (GoTime != vsync) {
		   /*Warning("Align on vsync off!\n"); */
                   GoTime = vsync;
		   }
		}
	   }

	   					/* Get sac start data 	*/
	   int sac_start_offset = Get_oValue(1, 't', -50);
	   int sac_start = Get_Saccade_Time(1, 1, GoTime+sac_start_offset, 0);
	   float Start_H = SacPosition_H;	/* Set by Get_Sac_Time	*/
	   float Start_V = SacPosition_V;

	   int sac_end = Get_Saccade_Time(0, 1, sac_start-50, 0);
	   float End_H = SacPosition_H;		/* Set by Get_Sac_Time	*/
	   float End_V = SacPosition_V;		/* set peakvel vars:	*/

	   int peaktime;

	   while ((sac_start != FAIL) &&
		  (sac_end   != FAIL) &&
		  ((sac_end-sac_start) < 0)) {
		  	/* Short RTs often = blink+sac; don't redo those*/
	      sac_start = Get_Saccade_Time(1, 1, GoTime+sac_end, 0);
	      Start_H = SacPosition_H;		/* Set by Get_Sac_Time	*/
	      Start_V = SacPosition_V;

	      sac_end = Get_Saccade_Time(0, 1, sac_start-50, 0);
	      End_H = SacPosition_H;		/* Set by Get_Sac_Time	*/
	      End_V = SacPosition_V;		/* set peakvel vars:	*/
	      }

	   /* Small saccade?  Try again: */
	   while ((sac_start != FAIL) &&
		   (sac_start < 160) && 
		  (sqrt((Start_H-End_H)*(Start_H-End_H) +
	                (Start_V-End_V)*(Start_V-End_V)) < 4)) {
	       int save_time = sac_start;
	       sac_start = Get_Saccade_Time(1, 1, sac_start+60, 0);
	       if ((sac_start > GoTime + 600) || 	/* Too late	*/
	           (sac_start == save_time)) {		/* In a loop	*/
	           sac_start = save_time;		/* Restore old	*/
		   break;
	        } else {				/* OK: use new	*/
		   fprintf(stderr, "Small early sac (%3d ms, %3.1f deg);",
		     save_time-GoTime,
		     sqrt((Start_H-End_H)*(Start_H-End_H) +
			  (Start_V-End_V)*(Start_V-End_V)));
	   	   Start_H = SacPosition_H;	/* Set by Get_Sac_Time	*/
	   	   Start_V = SacPosition_V;
	           sac_end = Get_Saccade_Time(0, 1, sac_start-50, 0);
		   End_H = SacPosition_H;	/* Set by Get_Sac_Time	*/
		   End_V = SacPosition_V;
		   fprintf(stderr, " using later one (%d ms, %.1f)\n",
		     sac_start-GoTime,
		     sqrt((Start_H-End_H)*(Start_H-End_H) +
			  (Start_V-End_V)*(Start_V-End_V)));
		   }
	       }

	   if (sac_end != FAIL)  
	      peaktime = Get_Saccade_Peak_Velocity(1, sac_start-50, 0);
	   	/* Unsed variable, but need call to set peak velocity	*/
	   else {
	      SacPeakVelocity_H = SacPeakVelocity_V = 0.;
	      sac_end = sac_start = FAIL + GoTime;
	      }

	   /* *********************************************************	*/
	   /* Get limb timing	*/
	   int limb_start = FAIL;
	   int limb_end = FAIL;
	   float Arm_Start_H = FAIL, Arm_Start_V = FAIL,
                 Arm_End_H   = FAIL,   Arm_End_V = FAIL;

	   if (Get_oValue(1, 'a', 1) != -1) {		/* If not 'skip' */

	   limb_start = Get_Button_Time(0,-1,1,GoTime,0);
	   limb_end   = Get_Button_Time(1,-1,1,GoTime,0);

	   if ((ButtonCount_Header()==0) || 
	       (limb_start == FAIL) ||
	       (Get_dataValue_From_CmdLine() == 1)) {	/* Why is this here?*/

	      limb_start = Get_Arm_Move_Time(GoTime, 0);

	      if (limb_start < GoTime) {		/* No start	*/
		  limb_start = limb_end = FAIL;
	       } else if (Get_DataValue_From_CmdLine() == 1) {
		  limb_end = FAIL;
	       } else {
	         limb_end =   Get_Arm_Stop_Time(limb_start+200, 0);
	         if (limb_end == FAIL) { /* Early lift? Back up & retry	*/
		     /* fprintf(stderr, "DIAG: failed; try again\n"); */
	             limb_end = Get_Arm_Stop_Time(limb_start+450, 0);
		     }
	         }
	      }
	   Get_ArmPosition(GoTime - Get_AlignTime(),
                           GoTime - Get_AlignTime()+40,
                              &Arm_Start_H, &Arm_Start_V);

           if (TimeRecorded(limb_end-Get_AlignTime()+Get_ZeroTime(),
           		    limb_end-Get_AlignTime()+Get_ZeroTime()+10))
                 Get_ArmPosition(limb_end - Get_AlignTime(),
                                 limb_end - Get_AlignTime()+10,
                              &Arm_End_H, &Arm_End_V);

	   }


	   if (RunNumber != RunNumber_Header()) {	/* New run??	*/
	       RunNumber =  RunNumber_Header();		/* Remember it	*/
	       SequentialRun++;				/* And tally it	*/
	       }	/* Problem: trial # ambiguous if run # changes	*/

           fprintf(file,
		"%3d %3d %2d  %3d %8.2f %8.2f  %8.2f %8.2f %5d  %5d %5d %5d %5d   %.2f %.2f %.2f %.2f",
		 trial + SequentialRun * 10000,/* Make trial# unambig	*/
	   	 StackNumber_Header(),
		 TableNumber_Header(),
		 sac_end - sac_start,			/* Sac duration	*/
		 End_H-Start_H,				/* Sac amplitude*/
		 End_V-Start_V,
		 SacPeakVelocity_H,			/* Sac velocity	*/
		 SacPeakVelocity_V,
		 sac_start - GoTime,			/* Sac latency	*/
		 (limb_start == FAIL) ? FAIL : limb_start - GoTime,
		 (limb_start == FAIL) ? FAIL : limb_start - GoTime,
		 (limb_start == FAIL) ? FAIL : limb_end - GoTime,
		 (limb_start == FAIL) ? FAIL : limb_end - GoTime,
                 Arm_Start_H, Arm_Start_V, Arm_End_H, Arm_End_V);




	   if (FindSecondLimb) {
	   /* ONLY if FindSecondLimb [which works only for buttons]	*/
	      int limb2_start = limb_start;
	      int FirstButton;
	      int SecondButton;

	      extern int ButtonPattern, ButtonPrevious;
	      int b;

	      /* Used to not do this if limb_start was fail from above code
	       * removed that on 3-2020 LHS
	       */
	      limb_start= Get_Button_Time(0,-1,1,GoTime,0); /* Set externs */
	      FirstButton = ButtonPrevious - ButtonPattern;

	      /* Rarely he completes 1 reach before starting the next;
	       * bounce on the target means the TARGET registers as the
	       * start time for the 2nd limb.  Not correcting that.
	       */

	      for (b=0; b<9; b++)
	         if (FirstButton & (int)rint((pow(2, b))))
		    break;

	      if (FirstButton != (int) rint(pow(2,b))) {  /* 2 at once?*/
		 limb2_start = limb_start;
		 SecondButton = FirstButton - (int) rint(pow(2,b));
		 FirstButton -= SecondButton;		/* Added 5-2019	*/
#		 if DEBUG
		 fprintf(stderr, "%d not %d (2^%d); 2nd = %d = %d - %d\n",
		    FirstButton, 
	            (int) rint(pow(2,b)),
		    b,
		    SecondButton,
		    FirstButton,
	            (int) rint(pow(2,b)));
#		 endif

	       } else {
	     	    /* Walk forward in time til you find another button off */
	         do {
	            limb2_start = Get_Button_Time(0, -1, 1, ++limb2_start, 0);
		 } while ((ButtonPrevious-ButtonPattern == FirstButton) &&
	                  (limb2_start < limb_start + 600));
	
	         SecondButton = ButtonPrevious - ButtonPattern;
	         }
              fprintf(file, "   %4d %d %d",	/* Works only for buttons*/
		    (limb2_start == FAIL) ? FAIL : limb2_start - GoTime,
		     FirstButton,			/* button #1	*/
		     SecondButton);
	      }

	   fprintf(file, "\n");
	   }
	
	fclose(file);
	}
/* ********************************************************************	*/

/* FUNCTION Movement_times65() */
	 /* Eye and limb data! */
	/* MUST BE ALIGNED ON THE 'GO' SIGNAL !! */
	/* Simpler version of 64, but needs a touch panel	*/
void Movement_times65() {
	FILE *file;
	int  RunNumber;		/* Run number may change	*/
	int  SequentialRun = 0;	/* Count runs, chg TrialNumber to reflect */
	extern float SacPeakVelocity_H, SacPeakVelocity_V;
	extern float SacPosition_H, SacPosition_V;

	extern int Get_Saccade_Limited;
	extern int Get_Saccade_Stringent;

	Get_Saccade_Limited = 0;		/* Don't stop looking!	*/
	Get_Saccade_Stringent = 0;		/* Just find large ones	*/

	Rewind_InputFile();

	file = Open_Macro_Output("Movements", -1);	/* AFTER rewind	*/

	Read_Next_Trial(SKIP_DATA);		/* Get 1st header	*/
	RunNumber = RunNumber_Header();		/* Same thru-out file?	*/
	Rewind_InputFile();			/* Back to start	*/

	while (Read_Next_Trial(WITH_DATA)) {
	   int trial = TrialNumber_Input();		/* Trial #	*/
	   int GoTime = Interval_To_Stack_Time(0);	/* 'Go' signal	*/


           { int vsync = EventExtract(V_SYNC, TIME, 2);    /* Sync off	*/
	     if (vsync != FAIL) {
		if (vsync - GoTime > 40 || vsync < GoTime)
                    Warning("Odd V_SYNC event (behavior/movement.c)");
		else if (GoTime != vsync) {
		   /*Warning("Align on vsync off!\n"); */
                   GoTime = vsync;
		   }
		}
	   }

	   					/* Get sac start data 	*/
	   int sac_start_offset = Get_oValue(1, 't', -50);
	   int sac_start = Get_Saccade_Time(1, 1, GoTime+sac_start_offset, 0);
	   float Start_H = SacPosition_H;	/* Set by Get_Sac_Time	*/
	   float Start_V = SacPosition_V;

	   int sac_end = Get_Saccade_Time(0, 1, sac_start-50, 0);
	   float End_H = SacPosition_H;		/* Set by Get_Sac_Time	*/
	   float End_V = SacPosition_V;		/* set peakvel vars:	*/

	   int peaktime;

	   while ((sac_start != FAIL) &&
		  (sac_end   != FAIL) &&
		  ((sac_end-sac_start) < 0)) {
		  	/* Short RTs often = blink+sac; don't redo those*/
	      sac_start = Get_Saccade_Time(1, 1, GoTime+sac_end, 0);
	      Start_H = SacPosition_H;		/* Set by Get_Sac_Time	*/
	      Start_V = SacPosition_V;

	      sac_end = Get_Saccade_Time(0, 1, sac_start-50, 0);
	      End_H = SacPosition_H;		/* Set by Get_Sac_Time	*/
	      End_V = SacPosition_V;		/* set peakvel vars:	*/
	      }

	   /* Small saccade?  Try again: */
	   while ((sac_start != FAIL) &&
		   (sac_start < 160) && 
		  (sqrt((Start_H-End_H)*(Start_H-End_H) +
	                (Start_V-End_V)*(Start_V-End_V)) < 4)) {
	       int save_time = sac_start;
	       sac_start = Get_Saccade_Time(1, 1, sac_start+60, 0);
	       if ((sac_start > GoTime + 600) || 	/* Too late	*/
	           (sac_start == save_time)) {		/* In a loop	*/
	           sac_start = save_time;		/* Restore old	*/
		   break;
	        } else {				/* OK: use new	*/
		   fprintf(stderr, "Small early sac (%3d ms, %3.1f deg);",
		     save_time-GoTime,
		     sqrt((Start_H-End_H)*(Start_H-End_H) +
			  (Start_V-End_V)*(Start_V-End_V)));
	   	   Start_H = SacPosition_H;	/* Set by Get_Sac_Time	*/
	   	   Start_V = SacPosition_V;
	           sac_end = Get_Saccade_Time(0, 1, sac_start-50, 0);
		   End_H = SacPosition_H;	/* Set by Get_Sac_Time	*/
		   End_V = SacPosition_V;
		   fprintf(stderr, " using later one (%d ms, %.1f)\n",
		     sac_start-GoTime,
		     sqrt((Start_H-End_H)*(Start_H-End_H) +
			  (Start_V-End_V)*(Start_V-End_V)));
		   }
	       }

	   if (sac_end != FAIL)  
	      peaktime = Get_Saccade_Peak_Velocity(1, sac_start-50, 0);
	   	/* Unsed variable, but need call to set peak velocity	*/
	   else {
	      SacPeakVelocity_H = SacPeakVelocity_V = 0.;
	      sac_end = sac_start = FAIL + GoTime;
	      }


	   /* *********************************************************	*/
	   /* Get limb timing	*/
	   extern int Arm_SlideStart, Arm_LiftOff, Arm_TouchDown, Arm_SlideEnd;
	   float Arm_Start_H = FAIL, Arm_Start_V = FAIL,
	         Arm_End_H   = FAIL,   Arm_End_V = FAIL;

	   Get_Arm_Times(GoTime);

	   if (Arm_SlideEnd != FAIL) {	    /* Skip if no reach	*/
	      int SlideEnd = Arm_SlideEnd - Get_AlignTime(); 

	      if (SlideEnd > EventExtract(END_STACK, TIME, 1) - 100)
		  SlideEnd = EventExtract(END_STACK, TIME, 1) - 110;

	      Get_ArmPosition(GoTime-Get_AlignTime(),
			      GoTime-Get_AlignTime()+40, 
			      &Arm_Start_H, &Arm_Start_V);

	      if (! TimeRecorded(SlideEnd+   Get_ZeroTime(),
				 SlideEnd+10+Get_ZeroTime())) /* Not recorded? */
		  SlideEnd -= 25;			/* Close enough */

	      if (TimeRecorded(SlideEnd+   Get_ZeroTime(),  /* Still not?*/
			       SlideEnd+10+Get_ZeroTime())) /* Skip!	*/
	         Get_ArmPosition(SlideEnd,
			      SlideEnd+10,
			      &Arm_End_H, &Arm_End_V);

#	      define TEST_ALIGNMENT 0
#	      if (TEST_ALIGNMENT)
	      Get_ArmPosition(Arm_LiftOff-Get_AlignTime() - 60,
			      Arm_LiftOff-Get_AlignTime() - 20, 
			      &Arm_Start_H, &Arm_Start_V);
	      Get_ArmPosition(Arm_TouchDown+10 - Get_AlignTime(),
			      Arm_TouchDown+30 - Get_AlignTime(),
			      &Arm_End_H, &Arm_End_V);
#	      endif

	      }


	   if (RunNumber != RunNumber_Header()) {	/* New run??	*/
	       RunNumber =  RunNumber_Header();		/* Remember it	*/
	       SequentialRun++;				/* And tally it	*/
	       }	/* Problem: trial # ambiguous if run # changes	*/

           fprintf(file,
"%3d %3d %2d  %3d %8.2f %8.2f  %8.2f %8.2f %5d  %5d %5d  %5d %5d  %4.2f %4.2f  %4.2f %4.2f\n",
		 trial + SequentialRun * 10000,/* Make trial# unambig	*/
	   	 StackNumber_Header(),
		 TableNumber_Header(),
		 sac_end - sac_start,			/* Sac duration	*/
		 End_H-Start_H,				/* Sac amplitude*/
		 End_V-Start_V,
		 SacPeakVelocity_H,			/* Sac velocity	*/
		 SacPeakVelocity_V,
		 sac_start - GoTime,			/* Sac latency	*/
		 (Arm_SlideStart == FAIL) ? FAIL : Arm_SlideStart - GoTime,
		 (Arm_LiftOff == FAIL) ? FAIL : Arm_LiftOff - GoTime,
		 (Arm_TouchDown == FAIL) ? FAIL : Arm_TouchDown - GoTime,
		 (Arm_SlideEnd == FAIL) ? FAIL : Arm_SlideEnd - GoTime,
	      	 Arm_Start_H, Arm_Start_V, Arm_End_H, Arm_End_V);
	   }
	
	fclose(file);
	}
/* ********************************************************************	*/
