/* FILE latency.c */
     /* Macro 90, modelled on 63,64,86 */
/* ********************************************************************	*/

#include "../Deffs.h"

#include "../../event.h"
#include "../../deffs.h"				/* BUTTONS	*/
/* ********************************************************************	*/

/* ********************************************************************	*/

/* FUNCTION BimanualTimes90() */
	/* MUST BE ALIGNED ON THE 'GO' SIGNAL !! */
	/* Set "-D1" on saccade trials to skip Get_Arm_Stop_Time() errs	*/
	/* Can also call with 999 or 998 */
 	/* Set "-ot" to start looking for a saccade at some time re:'go'*/
        /*  Default is -50 ms, but you might want to go longer!         */
void BimanualTimes90(int FindSecondSac) {
	FILE *file;
	char Name[80];
	int  RunNumber;		/* Run number may change	*/
	int  SequentialRun = 0;	/* Count runs, chg TrialNumber to reflect */
	extern float SacPeakVelocity_H, SacPeakVelocity_V;
	extern float SacPosition_H, SacPosition_V;

	extern int Get_Saccade_Limited;
	extern int Get_Saccade_Stringent;
	Get_Saccade_Limited = 0;		/* Don't stop looking!	*/
	Get_Saccade_Stringent = 0;		/* Just find large ones	*/

	Rewind_InputFile();

	sprintf(Name, "Movements.s%d.%d.out",
		UnitNumber_Header(), RunNumber_Header());
	file = fopen(Name, (MACRO_APPENDS)?"a":"w");
	if (file==NULL) {
		fprintf(stderr, "Err opening %s", Name);
		Exit("", "Movement_times63()");
		}

	Read_Next_Trial(SKIP_DATA);		/* Get 1st header	*/
	RunNumber = RunNumber_Header();		/* Same thru-out file?	*/
	Rewind_InputFile();			/* Back to start	*/

	while (Read_Next_Trial(WITH_DATA)) {
	   int trial = TrialNumber_Input();		/* Trial #	*/
	   int GoTime = Interval_To_Stack_Time(0);	/* 'Go' signal	*/


           { int vsync = EventExtract(V_SYNC, TIME, 2);    /* Sync off     */
	     if (vsync != FAIL) {
		if (vsync - GoTime > 40 || vsync < GoTime)
                    Warning("Odd V_SYNC event (behavior/movement.c)");
		else if (GoTime != vsync) {
		   Warning("You should align this call on the cue to move!\n");
                   GoTime = vsync;
		   }
		}
	   }

	   					/* Get sac start data 	*/
	   int sac_start_offset = Get_oValue(1, 't', -50);
	   int sac_start = Get_Saccade_Time(1, 1, GoTime-sac_start_offset, 0);
	   float Start_H = SacPosition_H;	/* Set by Get_Sac_Time	*/
	   float Start_V = SacPosition_V;

	   					/* Get sac end data 	*/
	   int sac_end = Get_Saccade_Time(0, 1, sac_start-50, 0);
	   float End_H = SacPosition_H;		/* Set by Get_Sac_Time	*/
	   float End_V = SacPosition_V;

	   if (sac_start-GoTime < 75 && (	/* Early, centering sac?*/
		  (sqrt(End_H*End_H + End_V*End_V) < 5.) ||
		  (sqrt((End_H-Start_H)*(End_H-Start_H)+
		        (End_V-Start_V)*(End_V-Start_V)) < 5.))
	     ) {	/* If align on last acq, then early RT is ok	*/
	      sac_start = Get_Saccade_Time(1, 1, sac_start+75, 0);
	      Start_H = SacPosition_H;	/* Set by Get_Sac_Time	*/
	      Start_V = SacPosition_V;

	      sac_end = Get_Saccade_Time(0, 1, sac_start-50, 0);
	      End_H = SacPosition_H;		/* Set by Get_Sac_Time	*/
	      End_V = SacPosition_V;
	      }

	   int peaktime;			/* set peakvel vars:	*/
	   
	   if (sac_end != FAIL)  
	      peaktime = Get_Saccade_Peak_Velocity(1, GoTime-50, 0);
	   	/* Unsed variable, but need call to set peak velocity	*/
	   else {
	      SacPeakVelocity_H = SacPeakVelocity_V = 0.;
	      sac_end = sac_start = FAIL + GoTime;
	      }

	   if (RunNumber != RunNumber_Header()) {	/* New run??	*/
	       RunNumber =  RunNumber_Header();		/* Remember it	*/
	       SequentialRun++;				/* And tally it	*/
	       }	/* Problem: trial # ambiguous if run # changes	*/

    fprintf(file,"%3d %3d %2d  %3d %8.2f %8.2f  %8.2f %8.2f %5d\n",
		 trial + SequentialRun * 10000,/* Make trial# unambig	*/
	   	 StackNumber_Header(),
		 TableNumber_Header(),
		 sac_end - sac_start,			/* Sac duration	*/
		 End_H-Start_H,				/* Sac amplitude*/
		 End_V-Start_V,
		 SacPeakVelocity_H,			/* Sac velocity	*/
		 SacPeakVelocity_V,
		 sac_start - GoTime);			/* Sac latency	*/

	   if (FindSecondSac) {		/* Look for 2nd saccade ? */
	      int sac_start2 = Get_Saccade_Time(1, 1, sac_end+80, 0);
	      float Start_H2 = SacPosition_H;
	      float Start_V2 = SacPosition_V;
	      int sac_end2 = Get_Saccade_Time(0, 1, sac_end+80, 0);
	      float End_H2 = SacPosition_H;
	      float End_V2 = SacPosition_V;

	      /* If 2nd sac is same hemifield, don't use - try again!	*/
	      if ((fabs(Start_H2) > fabs(Start_V2)) ?
	 	 ((signbit(Start_H2) == signbit(Start_H)) || 
		 				(fabs(Start_H2) < 4.)) :
	 	 ((signbit(Start_V2) == signbit(Start_V)) ||
		 				(fabs(Start_H2) < 4.)))  {
	        sac_start2 = Get_Saccade_Time(1, 1, sac_end2+50, 0);
	        Start_H2 = SacPosition_H;
	        Start_V2 = SacPosition_V;
	        sac_end2 = Get_Saccade_Time(0, 1, sac_end2+50, 0);
	        End_H2 = SacPosition_H;
	        End_V2 = SacPosition_V;
		}

	      /* If 3rd sac in same hemifield, consider it a FAIL	*/
	      if ((fabs(Start_H2) > fabs(Start_V2)) ?
	 	 ((signbit(Start_H2) == signbit(Start_H)) || 
		 				(fabs(Start_H2) < 4.)) :
	 	 ((signbit(Start_V2) == signbit(Start_V)) ||
		 				(fabs(Start_H2) < 4.)))
		 sac_end2 = FAIL;	/* Don't use it!		*/

	      if (sac_end2 != FAIL)  
	         peaktime = Get_Saccade_Peak_Velocity(1, sac_end2+50, 0);
	       else {
	         SacPeakVelocity_H = SacPeakVelocity_V = 0.;
		 sac_end2 = sac_start2 = FAIL + GoTime;
	         }
	       
              fprintf(file,"   %3d %8.2f %8.2f  %8.2f %8.2f %5d\n",
		 sac_end2 - sac_start2,			/* Sac duration	*/
		 End_H2-Start_H2,			/* Sac amplitude*/
		 End_V2-Start_V2,
		 SacPeakVelocity_H,			/* Sac velocity	*/
		 SacPeakVelocity_V,
		 sac_start2 - GoTime);			/* Sac latency	*/
	      }


#	   define MAX_B  28
	   int i;
	   extern BUTTONS Buttons[];

	   /* Find 1st button after the 'go' time	*/
	   for (i = 0; i<ButtonCount_Header(); i++)
              if (Buttons[i].time > GoTime)
	         break;

	   if (i < ButtonCount_Header()) {
	     int skip = i, j, goal;
	     for (j=2; j<6; j++) {
		 goal = EventExtract(BUTTON_ACQUIRE_AND, ONE, j);
		 if (goal != 1 && goal != 4 && goal != 5)
		    break;
		 }

	     if (j >= 6 || goal == FAIL)	/* Never found a non-home button_acq	*/
	        goal = 0;

	     /* State the goal and the 'g' time */
	     fprintf(file, " %6d %4d\n", GoTime, goal);
	     if (ButtonCount_Header() - i > MAX_B) {
	        fprintf(stderr, "%d buttons is more than %d -- ",
			ButtonCount_Header() - i, MAX_B);
		Exit("Too many buttons -- increase 'MAX_B'",
						"BimanualTimes90()");
		}
	     /* Print out each button state (which buttons are pushed when) */
	     for (     ; i<ButtonCount_Header(); i++) {
	       fprintf(file, " %6d ", Buttons[i].time);
	       /* The first two versions, and the "& 0x3FFF", are because of
		* an odd bug.  Ignore it for now! LHS 11-2012 */
	       if (Buttons[i].value == 65535)
	          fprintf(file, " %4d\n", -(0x3FFF & Buttons[i-1].value));
	        else if (Buttons[i-1].value == 65535)
	          fprintf(file, " %4d\n", (0x3FFF & Buttons[i].value));
	        else
	          fprintf(file, " %4d\n", 
		    (0x3FFF & Buttons[i].value) -(0x3FFF & Buttons[i-1].value));
	        }
	     fprintf(file, "  ");
	     /*  If necessary, pad out to MAX_B with zeroes */
	     for (i = MAX_B - i + skip; i>0; i--)
	       fprintf(file, " 0 0");
	    
	    } else 				/* If no buttons past 'go'*/
	     for (i = MAX_B; i>=0; i--)
	       fprintf(file, " 0 0");

	   fprintf(file, "\n");
	   }
	
	fclose(file);
	}
/* ********************************************************************	*/

/* FUNCTION BimanualTimes997() */
	 /* Eye and limb data! */
	/* MUST BE ALIGNED ON THE 'GO' SIGNAL !! */
	/* Set "-D1" on saccade trials to skip Get_Arm_Stop_Time() errs	*/
void BimanualTimes997(int FindSecondSac) {
	FILE *file;
	char Name[80];
	int  RunNumber;		/* Run number may change	*/
	int  SequentialRun = 0;	/* Count runs, chg TrialNumber to reflect */
	int  DoOnly = 1;
	extern float SacPeakVelocity_H, SacPeakVelocity_V;
	extern float SacPosition_H, SacPosition_V;

	extern int Get_Saccade_Limited;
	extern int Get_Saccade_Stringent;
	Get_Saccade_Limited = 0;		/* Don't stop looking!	*/
	Get_Saccade_Stringent = 0;		/* Just find large ones	*/


	Rewind_InputFile();

	sprintf(Name, "Movements.s%d.%d.out",
		UnitNumber_Header(), RunNumber_Header());
	file = fopen(Name, (MACRO_APPENDS)?"a":"w");
	if (file==NULL) {
		fprintf(stderr, "Err opening %s", Name);
		Exit("", "Movement_times63()");
		}

	Read_Next_Trial(SKIP_DATA);		/* Get 1st header	*/
	RunNumber = RunNumber_Header();		/* Same thru-out file?	*/
	Rewind_InputFile();			/* Back to start	*/
	Keep_All_Data();			/* Crazy!		*/

	while (1) {
	   int trial, GoTime;

           UnStore_NoSkip('t');
	   Store_No_Skip('t', DoOnly, DoOnly);
	   
	   Rewind_InputFile();			/* Back to start	*/
	   if (Read_Trial(DoOnly++) == FAIL)
	      break;
	      
	   trial = TrialNumber_Input();		/* Trial #	*/
	   GoTime = Interval_To_Stack_Time(0);	/* 'Go' signal	*/

           { int vsync = EventExtract(V_SYNC, TIME, 2);    /* Sync off     */
	     if (vsync != FAIL) {
		if (vsync - GoTime > 40 || vsync < GoTime)
                    Warning("Odd V_SYNC event (behavior/movement.c)");
		else if (GoTime != vsync) {
		   Warning("You should align this call on the cue to move!\n");
                   GoTime = vsync;
		   }
		}
	   }

	   					/* Get sac start data 	*/
	   int sac_start = Get_Saccade_Time(1, 1, GoTime-50, 0);
	   float Start_H = SacPosition_H;	/* Set by Get_Sac_Time	*/
	   float Start_V = SacPosition_V;

	   					/* Get sac end data 	*/
	   int sac_end = Get_Saccade_Time(0, 1, sac_start-50, 0);
	   float End_H = SacPosition_H;		/* Set by Get_Sac_Time	*/
	   float End_V = SacPosition_V;

	   if (sac_start-GoTime < 75 && (	/* Early, centering sac?*/
		  (sqrt(End_H*End_H + End_V*End_V) < 5.) ||
		  (sqrt((End_H-Start_H)*(End_H-Start_H)+
		        (End_V-Start_V)*(End_V-Start_V)) < 5.))
	     ) {	/* If align on last acq, then early RT is ok	*/
	      sac_start = Get_Saccade_Time(1, 1, sac_start+75, 0);
	      Start_H = SacPosition_H;	/* Set by Get_Sac_Time	*/
	      Start_V = SacPosition_V;

	      sac_end = Get_Saccade_Time(0, 1, sac_start-50, 0);
	      End_H = SacPosition_H;		/* Set by Get_Sac_Time	*/
	      End_V = SacPosition_V;
	      }

	   int peaktime;			/* set peakvel vars:	*/
	   
	   if (sac_end != FAIL)  
	      peaktime = Get_Saccade_Peak_Velocity(1, GoTime-50, 0);
	   	/* Unsed variable, but need call to set peak velocity	*/
	   else {
	      SacPeakVelocity_H = SacPeakVelocity_V = 0.;
	      sac_end = sac_start = FAIL + GoTime;
	      }

	   if (RunNumber != RunNumber_Header()) {	/* New run??	*/
	       RunNumber =  RunNumber_Header();		/* Remember it	*/
	       SequentialRun++;				/* And tally it	*/
	       }	/* Problem: trial # ambiguous if run # changes	*/

    fprintf(file,"%3d %3d %2d  %3d %8.2f %8.2f  %8.2f %8.2f %5d\n",
		 trial + SequentialRun * 10000,/* Make trial# unambig	*/
	   	 StackNumber_Header(),
		 TableNumber_Header(),
		 sac_end - sac_start,			/* Sac duration	*/
		 End_H-Start_H,				/* Sac amplitude*/
		 End_V-Start_V,
		 SacPeakVelocity_H,			/* Sac velocity	*/
		 SacPeakVelocity_V,
		 sac_start - GoTime);			/* Sac latency	*/

	   if (FindSecondSac) {		/* Look for 2nd saccade ? */
	      sac_start = Get_Saccade_Time(1, 1, sac_end+100, 0);
	      Start_H = SacPosition_H;	/* Set by Get_Sac_Time	*/
	      Start_V = SacPosition_V;
	      sac_end = Get_Saccade_Time(0, 1, sac_end+100, 0);
	      End_H = SacPosition_H;		/* Set by Get_Sac_Time	*/
	      End_V = SacPosition_V;		/* set peakvel vars:	*/

	      if (sac_end != FAIL)  
	         peaktime = Get_Saccade_Peak_Velocity(1, sac_end+50, 0);
	       else {
	         SacPeakVelocity_H = SacPeakVelocity_V = 0.;
		 sac_end = sac_start = FAIL + GoTime;
	         }
              fprintf(file,"   %3d %8.2f %8.2f  %8.2f %8.2f %5d\n",
		 sac_end - sac_start,			/* Sac duration	*/
		 End_H-Start_H,				/* Sac amplitude*/
		 End_V-Start_V,
		 SacPeakVelocity_H,			/* Sac velocity	*/
		 SacPeakVelocity_V,
		 sac_start - GoTime);			/* Sac latency	*/
	      }


#	   define MAX_B  28
	   int i;
	   extern BUTTONS Buttons[];

	   /* Find 1st button after the 'go' time	*/
	   for (i = 0; i<ButtonCount_Header(); i++)
              if (Buttons[i].time > GoTime)
	         break;

	   if (i < ButtonCount_Header()) {
	     int skip = i, j, goal;
	     for (j=2; j<6; j++) {
		 goal = EventExtract(BUTTON_ACQUIRE_AND, ONE, j);
		 if (goal != 1 && goal != 4 && goal != 5)
		    break;
		 }

	     if (j >= 6 || goal == FAIL)	/* Never found a non-home button_acq	*/
	        goal = 0;

	     /* State the goal and the 'g' time */
	     fprintf(file, " %6d %4d\n", GoTime, goal);
	     if (ButtonCount_Header() - i > MAX_B) {
	        fprintf(stderr, "%d buttons is more than %d -- ",
			ButtonCount_Header() - i, MAX_B);
		Exit("Too many buttons -- increase 'MAX_B'",
						"BimanualTimes90()");
		}
	     /* Print out each button state (which buttons are pushed when) */
	     for (     ; i<ButtonCount_Header(); i++) {
	       fprintf(file, " %6d ", Buttons[i].time);
	       /* The first two versions, and the "& 0x3FFF", are because of
		* an odd bug.  Ignore it for now! LHS 11-2012 */
	       if (Buttons[i].value == 65535)
	          fprintf(file, " %4d\n", -(0x3FFF & Buttons[i-1].value));
	        else if (Buttons[i-1].value == 65535)
	          fprintf(file, " %4d\n", (0x3FFF & Buttons[i].value));
	        else
	          fprintf(file, " %4d\n", 
		    (0x3FFF & Buttons[i].value) -(0x3FFF & Buttons[i-1].value));
	        }
	     fprintf(file, "  ");
	     /*  If necessary, pad out to MAX_B with zeroes */
	     for (i = MAX_B - i + skip; i>0; i--)
	       fprintf(file, " 0 0");
	    
	    } else 				/* If no buttons past 'go'*/
	     for (i = MAX_B; i>=0; i--)
	       fprintf(file, " 0 0");

	   fprintf(file, "\n");
	   }
	
	fclose(file);
	}
/* ********************************************************************	*/
