/* FILE Functions.h */
     /*  Public function declarations FOR MACROS */

/* align.c */	int Get_AlignTime();

/* anova.c */   double *anova(double **rankdata, int rows, int cols);

/* arm.c */	int  Get_Arm_Move_Time(int time, int InitialAlignment);
/* arm.c */	int  Get_Arm_Stop_Time(int time, int InitialAlignment);
/* arm.c */	int  Get_Arm_Times(int time);

/* behav.c */	void Get_EyePosition(int from, int to, float *h, float *v);
/* behav.c */	void Get_ArmPosition(int from, int to, float *h, float *v);
/* behav.c */	void Get_ArmWidth(int from, int to, float *h, float *v);
/* behav.c */   int  TimeRecorded(int from, int to);

/* button.c*/	int  Get_Button_Time(int OnOff, int bit, int occurrence,
					int from, int InitalAlignment);

/* config.c */	float function_P_CRITERIA();
/* config.c */	int function_PREF_MINUS_NULL();
/* config.c */  int function_MACRO_APPENDS();

/* coord.c */	int  TopCoord(int percent);
/* coord.c */	int  Setup_Coords_For_TrialType(int type);
/* coord.c */	int  RightEdgeCoord();
/* coord.c */	int  LeftEdgeCoord();

/* event.c */	int  EventExtract(int type, int which, int occurrence);
/* event.c */	int  AcquireEventExtract(int behav, int target, 
						    int which, int occurrence);
/* event.c */	int  MultiEventExtract(int types[], int which, int occurrence);
/* event.c */	int  TargetEventExtract(int target, int which, int occurrence);
/* event.c */	int  TargetOffEventExtract(int targ,int which,int occurrence);
/* event.c */	int  AnyTargetEventExtract(int which, int occurrence);
/* event.c */	int  AnyTargetOffEventExtract(int which,int occurrence);
/* event.c */	int  EventNameToNumber(char *name);
/* event.c */   int  UseVSYNC(int time);

/* head.c */	int    FrameCount_Header();
/* head.c */	int    SpikeCount_Header(int i);
/* head.c */	int    SwitchCount_Header();
/* head.c */	int    ChannelCount_Header();
/* head.c */	int    MsPerFrame_Header();
/* head.c */	int    TableNumber_Header();
/* head.c */	int    StackNumber_Header();
/* head.c */	int    TrialNumber_Header();
/* head.c */	char  *StackName_Header();
/* head.c */	int    UnitNumber_Header();
/* head.c */	int    RunNumber_Header();
/* head.c */	char   MonkChar_Header();
/* head.c */	char  *MonkName_Header();
/* head.c */	int    ChairAt_Header();
/* head.c */	char  *Date_From_Header();
/* head.c */	void   Warning(char *string);
/* head.c */	void   Set_StackNumber_Header(int i);
/* head.c */	void   Set_ClassNumber_Header(int i);
/* head.c */	void   Set_StackName_Header(char *new);
/* head.c */	int    ButtonCount_Header();
/* heac.c */	int    Get_UnitChannel_Header();

/* input.c */	void   Rewind_InputFile();
/* input.c */	int    TrialNumber_Input();
/* input.c */	int    Read_Next_Trial(int SkipDataFlag);
/* input.c */	short *Read_Skipped_Data();
/* input.c */	void   Exit(char *string, char *name);

/* interval.c*/	int   Get_Interval_Type();
/* interval.c*/	int   Get_Interval_Begin(int which_interval);
/* interval.c*/	int   Get_Interval_End  (int which_interval);
/* interval.c*/	float Get_Interval_Mean (int type, int which_interval);
/* interval.c*/	float Get_Interval_SEM  (int type, int which_interval);
/* interval.c*/	float Get_Interval_SD   (int type, int which_interval);
/* interval.c*/	int   Get_Interval_Count(int type, int which_interval);
/* interval.c*/	int  *Get_Interval_Data (int type, int which_interval);
/* interval.c*/	int  *Get_Interval_TrialNumber (int type);
/* interval.c*/ int   Spikes_In_Interval(int interval);
/* interval.c*/	float Ttest_On_Interval(int interval, int type1,
						int type2, int sides);
/* interval.c*/	float Ttest_Vs_Zero_On_Interval(int interval,int type,int sides);
/* interval.c*/	float Ttest_On_Two_Intervals(int type, int sides);
/* interval.c*/ float Anova_On_Interval();

/* layout.c */	int  List_Length (int list);
/* layout.c */	int  List_Element(int list,int n);
/* layout.c */	int  List_Index(int find, int list);
/* layout.c */	int  Match_List(int trialtype, int list, int n);

/* macro.c */	int  Get_dataValue_From_CmdLine();
/* macro.c */	int  Get_DataValue_From_CmdLine();
/* macro.c */	int  Get_oValue(int number, char ch, int Default);
/* macro.c */	FILE *Open_Macro_Output(char *name, int AddNameUnitRun);

/* main.c */	char *Get_CallCommand();

/* merge.c */	int  MergeStack(int stack);
/* merge.c */	int  MergeTable(int table);

/* output.c */	void  Open_OutputFile(char *inputname, char *suffix);
/* output.c */	void  Write_OutputFile();
/* output.c */	void  Close_OutputFile();

/* ps.c */	void move(int x, int y);
/* ps.c */	void cont(int x, int y);
/* ps.c */	void box(int x0, int y0, int x1, int y1);
/* ps.c */	void erase(void);
/* ps.c */	void arc(int xc, int yc, int x0, int y0, int x1, int y1);
/* ps.c */	void circle(int x, int y, int r);
/* ps.c */	void point(int x, int y);
/* ps.c */	void SetColor(int red, int green, int blue);
/* ps.c */	void SetLineWidth(int width);
/* ps.c */	void linemod(char *s);
/* ps.c */	void fill(int level);
/* ps.c */	void label(char *s);
/* ps.c */	void fontsize(int size);
/* ps.c */	void fontname (char *s);
/* ps.c */	void rotate (int w, int h, int angle);
/* ps.c */	void alabel (int x_justify, int y_justify, char *s);

/* sac.c */	int  Get_Saccade_Time(int SacStart,
			int forward, int begin, int InitialAlignment);
/* sac.c */	int Get_Saccade_Peak_Velocity(
			int forward, int begin, int InitialAlignment);

/* switch.c */	int  Get_Switch_Time(int OnOff, int time, int InitialAlignment);

/* time.c */	int  DurationTime();
/* time.c */	int  Get_ZeroTime();
/* time.c */	int  Get_TargetTime(int i);
/* time.c */	int  Get_AcquireTime(int i);
/* time.c */	char *AlignTime_String();
/* time.c */	char *Get_AlignmentTime();
/* time.c */	int  Get_TapeOnTime();
/* time.c */	int  Interval_To_Stack_Time(int interval_time);

/* title.c */	char *Get_Title_From_CmdLine();

/* trial.c */	int  Get_TrialType_Info(int type, int what);
/* trial.c */	int  Count_TrialTypes();
/* trial.c */	int  Get_StackClass_TrialType(int stack, int table);
/* trial.c */	int  Get_TrialType();

/* ttest.c */	float Ttest(int *data1, int count1,
				int *data2, int count2, int sides);
/* ttest.c */	float Ttest_short(float mean1, int count1, float sem1,
				  float mean2, int count2, float sem2,
				  int sides);
/* ttest.c */	float Ttest_vs_zero(int *data, int count, int sides);

/* util.c    in the MAIN DIRECTORY */
/* util.c */	void SetColorByTrialType(int type);
/* util.c */	void SetColorByStackIndex(int stackindex);
/* util.c */	void SetColorByStackNumber(int stacknumber);
/* util.c */	void Color(int a, int b, int c);
/* util.c */	int  TargetLocation(int targ);
/* util.c */	int  Coord_To_TargetCode(int x, int y);

/* util.c in the _macro subdirectory */
/* util.c */ int MinAndReportDiff(int a, int b);
/* util.c */ int Find_Best_Direction_Across_Stacks(int *stacks, int stackcount);
/* util.c */ int Find_Best_Direction_In_Averaged_Stacks(
						  int *stacks, int stackcount);
/* util.c */ int Is_A_TrialType_Missing(int best, int *stacks, int stackcount);
/* util.c */ int Opposite_Class(int best);
